/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.socket.sl;

import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.socket.IOPoolProvider;
import de.schlichtherle.truezip.socket.spi.IOPoolDecorator;
import de.schlichtherle.truezip.socket.spi.IOPoolService;
import de.schlichtherle.truezip.util.ServiceLocator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.ServiceConfigurationError;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class IOPoolLocator
implements IOPoolProvider {
    public static final IOPoolLocator SINGLETON = new IOPoolLocator();

    private IOPoolLocator() {
    }

    @Override
    public IOPool<?> get() {
        return Boot.pool;
    }

    private static final class Boot {
        static final IOPool<?> pool;

        private Boot() {
        }

        private static IOPool<?> create(ServiceLocator locator, Logger logger) {
            IOPoolService service = locator.getService(IOPoolService.class, null);
            if (null == service) {
                Iterator<IOPoolService> i = locator.getServices(IOPoolService.class);
                while (i.hasNext()) {
                    int np;
                    IOPoolService newService = i.next();
                    logger.log(Level.CONFIG, "located", newService);
                    if (null == service) {
                        service = newService;
                        continue;
                    }
                    int op = service.getPriority();
                    if (op < (np = newService.getPriority())) {
                        service = newService;
                        continue;
                    }
                    if (op != np) continue;
                    logger.log(Level.WARNING, "collision", new Object[]{op, service, newService});
                }
            }
            if (null == service) {
                throw new ServiceConfigurationError(MessageFormat.format(ResourceBundle.getBundle(IOPoolLocator.class.getName()).getString("null"), IOPoolService.class));
            }
            logger.log(Level.CONFIG, "using", service);
            IOPool<?> pool = service.get();
            logger.log(Level.CONFIG, "result", pool);
            return pool;
        }

        private static <B extends IOPool.Entry<B>> IOPool<B> decorate(IOPool<B> pool, ServiceLocator locator, Logger logger) {
            ArrayList<IOPoolDecorator> list = new ArrayList<IOPoolDecorator>();
            Iterator<IOPoolDecorator> i = locator.getServices(IOPoolDecorator.class);
            while (i.hasNext()) {
                list.add(i.next());
            }
            IOPoolDecorator[] array = list.toArray(new IOPoolDecorator[list.size()]);
            Arrays.sort(array, new Comparator<IOPoolDecorator>(){

                @Override
                public int compare(IOPoolDecorator o1, IOPoolDecorator o2) {
                    return o1.getPriority() - o2.getPriority();
                }
            });
            for (IOPoolDecorator decorator : array) {
                logger.log(Level.CONFIG, "decorating", decorator);
                pool = decorator.decorate(pool);
                logger.log(Level.CONFIG, "result", pool);
            }
            return pool;
        }

        static {
            Class<IOPoolLocator> clazz = IOPoolLocator.class;
            Logger logger = Logger.getLogger(clazz.getName(), clazz.getName());
            ServiceLocator locator = new ServiceLocator(clazz.getClassLoader());
            pool = Boot.decorate(Boot.create(locator, logger), locator, logger);
        }
    }
}

