/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs.archive.tar;

import de.schlichtherle.truezip.entry.Entry;
import de.schlichtherle.truezip.fs.FsArchiveEntries;
import de.schlichtherle.truezip.fs.FsArchiveEntry;
import de.schlichtherle.truezip.socket.IOPool;
import de.schlichtherle.truezip.util.Pool;
import java.io.IOException;
import java.util.Date;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;

public class TarDriverEntry
extends TarArchiveEntry
implements FsArchiveEntry,
Pool.Releasable<IOException> {
    private static final int SIZE = 1;
    private static final int MODTIME = 2;
    private byte init;
    @CheckForNull
    private IOPool.Entry<?> temp;

    public TarDriverEntry(String name) {
        super(name, true);
        super.setUserName(System.getProperty("user.name", ""));
    }

    protected TarDriverEntry(String name, TarArchiveEntry template) {
        super(name, true);
        super.setMode(template.getMode());
        this.setModTime0(template.getModTime().getTime());
        this.setSize0(template.getSize());
        super.setUserId(template.getUserId());
        super.setUserName(template.getUserName());
        super.setGroupId(template.getGroupId());
        super.setGroupName(template.getGroupName());
        super.setLinkName(template.getLinkName());
    }

    private boolean isInit(int mask) {
        return 0 != (this.init & mask);
    }

    private void setInit(int mask, boolean init) {
        this.init = init ? (byte)(this.init | mask) : (byte)(this.init & ~mask);
    }

    @Nullable
    IOPool.Entry<?> getTemp() {
        return this.temp;
    }

    void setTemp(@CheckForNull IOPool.Entry<?> temp) {
        this.temp = temp;
    }

    @Override
    public void release() throws IOException {
        if (null == this.temp) {
            return;
        }
        this.temp.release();
        this.temp = null;
    }

    @Override
    public Entry.Type getType() {
        return this.isDirectory() ? Entry.Type.DIRECTORY : Entry.Type.FILE;
    }

    @Override
    public long getSize() {
        return this.isInit(1) ? super.getSize() : -1L;
    }

    @Override
    public void setSize(long size) {
        this.setSize0(size);
    }

    private void setSize0(long size) {
        boolean known = -1L != size;
        super.setSize(known ? size : 0L);
        this.setInit(1, known);
    }

    @Override
    public long getSize(Entry.Size type) {
        switch (type) {
            case DATA: 
            case STORAGE: {
                return this.getSize();
            }
        }
        return -1L;
    }

    @Override
    public boolean setSize(Entry.Size type, long size) {
        if (Entry.Size.DATA != type) {
            return false;
        }
        this.setSize(size);
        return true;
    }

    @Override
    public Date getModTime() {
        return this.isInit(2) ? super.getModTime() : new Date(-1L);
    }

    @Override
    public void setModTime(long time) {
        this.setModTime0(time);
    }

    private void setModTime0(long time) {
        boolean known = -1L != time;
        super.setModTime(known ? time : 0L);
        this.setInit(2, known);
    }

    @Override
    public void setModTime(Date time) {
        this.setModTime(time.getTime());
    }

    @Override
    public long getTime(Entry.Access type) {
        if (Entry.Access.WRITE != type) {
            return -1L;
        }
        long time = this.getModTime().getTime();
        return 0L <= time ? time : -1L;
    }

    @Override
    public boolean setTime(Entry.Access type, long time) {
        if (Entry.Access.WRITE != type) {
            return false;
        }
        this.setModTime(time);
        return true;
    }

    @Override
    public boolean equals(Object that) {
        return super.equals(that);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return FsArchiveEntries.toString(this);
    }
}

