/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.log4j.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;

public class KeyAndTrustManager {
    private static final Logger logger = Logger.getLogger(KeyAndTrustManager.class);
    private static boolean initialised;
    private static SSLSocketFactory sslFactory;

    public static String getClientTrustStore(Configuration configuration, String password) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException {
        String trustStoreFilename = configuration.getString("security", "client-truststore");
        if (trustStoreFilename == null || "".equals(trustStoreFilename)) {
            return null;
        }
        String brokerHost = configuration.getString("messaging", "broker-host");
        URL remoteTrustStore = new URL(configuration.getConfigRootURL() + trustStoreFilename);
        File localTrustStore = new File(DirectoryLayout.getInstance().getSecurityDir() + File.separator + brokerHost + "-" + trustStoreFilename);
        if (!localTrustStore.exists()) {
            Throwable throwable;
            logger.info((Object)"keystore file missing, exporting it");
            KeyStore original = KeyStore.getInstance(KeyStore.getDefaultType());
            try {
                throwable = null;
                try (InputStream urlStream = remoteTrustStore.openStream();){
                    original.load(urlStream, password.toCharArray());
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
            }
            catch (FileNotFoundException e) {
                throw new KeyStoreException("cannot load server's SSL certificate", e);
            }
            throwable = null;
            try (FileOutputStream out = new FileOutputStream(localTrustStore);){
                original.store(out, password.toCharArray());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        return localTrustStore.getPath();
    }

    public static void initialiseTrustStore() throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException, KeyStoreException, KeyManagementException {
        if (!initialised) {
            String trustStorePath;
            Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
            String password = configuration.getString("security", "storepass");
            if (DirectoryLayout.getInstance().getType() == DirectoryLayout.Type.CLIENT) {
                trustStorePath = KeyAndTrustManager.getClientTrustStore(configuration, password);
            } else {
                trustStorePath = configuration.getString("security", "server-truststore");
                if ("".equals(trustStorePath)) {
                    trustStorePath = null;
                }
            }
            if (trustStorePath != null) {
                System.setProperty("javax.net.ssl.keyStorePassword", password);
                System.setProperty("javax.net.ssl.trustStore", trustStorePath);
                if (DirectoryLayout.getInstance().getType() == DirectoryLayout.Type.CLIENT) {
                    KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
                    try (FileInputStream inputStream = new FileInputStream(trustStorePath);){
                        trustStore.load(inputStream, password.toCharArray());
                    }
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(trustStore);
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    ctx.init(null, tmf.getTrustManagers(), null);
                    sslFactory = ctx.getSocketFactory();
                }
            }
            if (!configuration.getBoolean("security", "verify-hostname")) {
                HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

                    @Override
                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            initialised = true;
        }
    }

    public static SslContextFactory createSslContextFactory(String keyStore, String keyStorePassword) throws NoSuchAlgorithmException, CertificateException, FileNotFoundException, KeyStoreException, IOException {
        SslContextFactory sslContextFactory = new SslContextFactory(keyStore);
        sslContextFactory.setKeyStorePassword(keyStorePassword);
        return sslContextFactory;
    }

    public static void configureSSL(URLConnection connection) {
        if (sslFactory != null && connection instanceof HttpsURLConnection) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(sslFactory);
        }
    }
}

