/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.FloatArrayListIterator;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FloatArrayList
implements List<Float> {
    private static final int DEFAULT_SIZE = 1024;
    private static final int MINIMUM_SIZE = 32;
    private float[] data;
    private int lastElement;

    public FloatArrayList() {
        this(1024);
    }

    public FloatArrayList(int size) {
        if (size < 32) {
            size = 32;
        }
        this.data = new float[size];
        this.lastElement = 0;
    }

    public FloatArrayList(float[] data) {
        this.data = data;
        this.lastElement = data.length;
    }

    public FloatArrayList(double[] data) {
        this(FloatArrayList.toFloatArray(data));
    }

    public FloatArrayList(Float[] data) {
        this(FloatArrayList.toFloatArray(data));
    }

    public FloatArrayList(Double[] data) {
        this(FloatArrayList.toFloatArray(data));
    }

    public FloatArrayList(List<Float> values) {
        this(values.toArray(new Float[0]));
    }

    private static float[] toFloatArray(double[] data) {
        float[] f = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            f[i] = (float)data[i];
        }
        return f;
    }

    private static float[] toFloatArray(Float[] data) {
        float[] f = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            f[i] = data[i].floatValue();
        }
        return f;
    }

    private static float[] toFloatArray(Double[] data) {
        float[] f = new float[data.length];
        for (int i = 0; i < data.length; ++i) {
            f[i] = data[i].floatValue();
        }
        return f;
    }

    private void internalAddElement(float element) {
        if (this.lastElement < this.data.length) {
            this.data[this.lastElement] = element;
            ++this.lastElement;
        } else {
            float[] old = this.data;
            this.data = new float[old.length * 2];
            System.arraycopy(old, 0, this.data, 0, old.length);
            this.internalAddElement(element);
        }
    }

    @Override
    public int size() {
        return this.lastElement;
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    public FloatArrayListIterator floatIterator() {
        return new InternalFloatArrayListIterator();
    }

    @Override
    public Iterator<Float> iterator() {
        return new InternalFloatArrayListIterator();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(Float element) {
        this.internalAddElement(element.floatValue());
        return true;
    }

    @Override
    public boolean add(float element) {
        this.internalAddElement(element);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Float> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends Float> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Float get(int index) {
        return new Float(this.data[index]);
    }

    public float getFloat(int index) {
        return this.data[index];
    }

    @Override
    public Float set(int index, Float element) {
        Float old = this.get(index);
        this.data[index] = element.floatValue();
        return old;
    }

    public void setFloat(int index, float element) {
        if (index > this.lastElement) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.data[index] = element;
    }

    @Override
    public void add(int index, Float element) {
        this.setFloat(index, element.floatValue());
    }

    public void addFloat(int index, float element) {
        this.setFloat(index, element);
    }

    @Override
    public Float remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Float> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Float> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<Float> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public float max() {
        float max = Float.MIN_VALUE;
        for (int i = 0; i < this.lastElement; ++i) {
            if (!(this.data[i] > max)) continue;
            max = this.data[i];
        }
        return max;
    }

    public float min() {
        float min = Float.MAX_VALUE;
        for (int i = 0; i < this.lastElement; ++i) {
            if (!(this.data[i] < min)) continue;
            min = this.data[i];
        }
        return min;
    }

    public double[] convertToPrimitiveDoubles() {
        double[] d = new double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            d[i] = this.data[i];
        }
        return d;
    }

    public Float[] convertToFloats() {
        Float[] f = new Float[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            f[i] = new Float(this.data[i]);
        }
        return f;
    }

    public Double[] convertToDoubles() {
        Double[] d = new Double[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            d[i] = new Double(this.data[i]);
        }
        return d;
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.lastElement; ++i) {
            s = s + this.data[i] + " ";
        }
        return s;
    }

    public class InternalFloatArrayListIterator
    implements FloatArrayListIterator {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < FloatArrayList.this.lastElement;
        }

        @Override
        public Float next() {
            return Float.valueOf(FloatArrayList.this.data[this.index++]);
        }

        @Override
        public float nextFloat() {
            return FloatArrayList.this.data[this.index++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

