/*
 * Decompiled with CFR 0.152.
 */
package com.sun.syndication.io.impl;

import com.sun.syndication.io.impl.PropertiesLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class PluginManager {
    private String[] _propertyValues;
    private Map _pluginsMap;
    private List _pluginsList;
    private List _keys;

    protected PluginManager(String propertyKey) {
        this._propertyValues = PropertiesLoader.getPropertiesLoader().getTokenizedProperty(propertyKey, ", ");
        this.loadPlugins();
        this._pluginsMap = Collections.unmodifiableMap(this._pluginsMap);
        this._pluginsList = Collections.unmodifiableList(this._pluginsList);
        this._keys = Collections.unmodifiableList(new ArrayList(this._pluginsMap.keySet()));
    }

    protected abstract String getKey(Object var1);

    protected List getKeys() {
        return this._keys;
    }

    protected List getPlugins() {
        return this._pluginsList;
    }

    protected Map getPluginMap() {
        return this._pluginsMap;
    }

    protected Object getPlugin(String key) {
        return this._pluginsMap.get(key);
    }

    private void loadPlugins() {
        ArrayList finalPluginsList = new ArrayList();
        this._pluginsList = new ArrayList();
        this._pluginsMap = new HashMap();
        try {
            Class[] classes = this.getClasses();
            for (int i = 0; i < classes.length; ++i) {
                Object obj = classes[i].newInstance();
                this._pluginsMap.put(this.getKey(obj), obj);
                this._pluginsList.add(obj);
            }
            Iterator<Object> i = this._pluginsMap.values().iterator();
            while (i.hasNext()) {
                finalPluginsList.add(i.next());
            }
            i = this._pluginsList.iterator();
            while (i.hasNext()) {
                Object plugin = i.next();
                if (finalPluginsList.contains(plugin)) continue;
                i.remove();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("could not instanciate plugin ", ex);
        }
    }

    private Class[] getClasses() throws ClassNotFoundException {
        ClassLoader classLoader = PluginManager.class.getClassLoader();
        ArrayList classes = new ArrayList();
        for (int i = 0; i < this._propertyValues.length; ++i) {
            Class<?> mClass = classLoader.loadClass(this._propertyValues[i]);
            classes.add(mClass);
        }
        Class[] array = new Class[classes.size()];
        classes.toArray(array);
        return array;
    }
}

