/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web;

import java.util.Collection;
import java.util.Collections;
import org.apache.activemq.broker.jmx.ConnectionViewMBean;
import org.apache.activemq.broker.jmx.SubscriptionViewMBean;
import org.apache.activemq.web.BrokerFacade;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionQuery {
    private final BrokerFacade mBrokerFacade;
    private String mConnectionID;

    public ConnectionQuery(BrokerFacade brokerFacade) {
        this.mBrokerFacade = brokerFacade;
    }

    public void destroy() {
    }

    public void setConnectionID(String connectionID) {
        this.mConnectionID = connectionID;
    }

    public String getConnectionID() {
        return this.mConnectionID;
    }

    public ConnectionViewMBean getConnection() throws Exception {
        String connectionID = this.getConnectionID();
        if (connectionID == null) {
            return null;
        }
        return this.mBrokerFacade.getConnection(connectionID);
    }

    public Collection<SubscriptionViewMBean> getConsumers() throws Exception {
        String connectionID = this.getConnectionID();
        if (connectionID == null) {
            return Collections.emptyList();
        }
        return this.mBrokerFacade.getConsumersOnConnection(connectionID);
    }
}

