/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.spring.util;

import java.io.File;
import java.io.FileFilter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.StringUtils;

public class SpringAntPathMatcherFileFilter
implements FileFilter {
    private static final transient Log LOG = LogFactory.getLog(SpringAntPathMatcherFileFilter.class);
    private AntPathMatcher matcher = new AntPathMatcher();
    private String[] excludes;
    private String[] includes;

    public boolean accept(File pathname) {
        return this.acceptPathName(pathname.getPath());
    }

    public boolean acceptPathName(String path) {
        path = StringUtils.replace((String)path, (String)File.separator, (String)"/");
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Filtering file: " + path));
        }
        if (this.excludes != null) {
            for (String exclude : this.excludes) {
                if (!this.matcher.match(exclude, path)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("File is excluded: " + path));
                }
                return false;
            }
        }
        if (this.includes != null) {
            for (String include : this.includes) {
                if (!this.matcher.match(include, path)) continue;
                if (LOG.isTraceEnabled()) {
                    LOG.trace((Object)("File is included: " + path));
                }
                return true;
            }
        }
        return false;
    }

    public String[] getExcludes() {
        return this.excludes;
    }

    public void setExcludes(String[] excludes) {
        this.excludes = excludes;
    }

    public String[] getIncludes() {
        return this.includes;
    }

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setExcludes(String excludes) {
        this.setExcludes(excludes.split(","));
    }

    public void setIncludes(String includes) {
        this.setIncludes(includes.split(","));
    }
}

