/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutComponent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutContainer;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.LayoutTool;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class TrackGroup
implements LayoutComponent,
LayoutContainer {
    protected List<Track> tracks = new LinkedList<Track>();
    protected GBrowserView view;
    protected boolean menuVisible = false;
    protected boolean visible = true;
    public SideMenu menu;
    private JButton resize;
    private int layoutHeight;

    public TrackGroup(GBrowserView view) {
        this.view = view;
        this.menu = new SideMenu();
    }

    public TrackGroup(Track track) {
        this(track.view);
        this.tracks.add(track);
    }

    public void addTrack(Track track) {
        this.tracks.add(track);
    }

    public List<Track> getTracks() {
        return this.tracks;
    }

    public GBrowserView getView() {
        return this.view;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
        this.menu.setVisible(visible);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isMenuVisible() {
        return this.visible && this.menuVisible;
    }

    public void setMenuVisible(boolean isVisible) {
        this.menuVisible = isVisible;
    }

    public String getName() {
        return "Track Group";
    }

    public void showOrHide(String name, boolean state) {
        for (Track track : this.tracks) {
            if (!track.getName().equals(name)) continue;
            track.setVisible(state);
            track.getView().redraw();
        }
    }

    @Override
    public Collection<? extends LayoutComponent> getLayoutComponents() {
        return this.tracks;
    }

    @Override
    public int getHeight() {
        return LayoutTool.getHeight(this, this.layoutHeight);
    }

    @Override
    public void setHeight(int height) {
        this.layoutHeight = height;
    }

    @Override
    public int getMinHeight() {
        return LayoutTool.getMinHeightSum(this);
    }

    @Override
    public int getFullHeight() {
        return LayoutTool.getFullHeight(this);
    }

    @Override
    public LayoutTool.LayoutMode getLayoutMode() {
        return LayoutTool.inferLayoutMode(this);
    }

    @Override
    public void setLayoutMode(LayoutTool.LayoutMode mode) {
    }

    @Override
    public void setDefaultLayoutMode() {
    }

    public class SideMenu
    extends JPanel
    implements ActionListener {
        public static final int WIDTH = 110;
        public static final int COLLAPSED_WIDTH = 20;
        int x;
        int y;
        private JPanel controls = new JPanel();
        int startControlsAt = 25;
        int lastControlAt = 0;
        protected boolean menuCollapsed = true;
        protected TrackGroup group = TrackGroup.this;

        public SideMenu() {
            this.setLayout(null);
            try {
                TrackGroup.this.resize = new JButton(new ImageIcon(this.getClass().getResource("/arrow_left.png").toURI().toURL()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TrackGroup.this.resize.setBackground(new Color(0, 0, 0, 0));
            TrackGroup.this.resize.setBorder(null);
            TrackGroup.this.resize.setBounds(1, 1, 20, 20);
            TrackGroup.this.resize.setOpaque(false);
            TrackGroup.this.resize.setFocusPainted(false);
            TrackGroup.this.resize.addActionListener(this);
            this.controls.setLayout(new BoxLayout(this.controls, 3));
            this.controls.setBounds(5, this.startControlsAt, 100, 100);
            this.controls.setVisible(!this.menuCollapsed);
            this.add(this.controls);
            this.add(TrackGroup.this.resize);
        }

        public void addItem(JComponent component) {
            this.controls.add(component);
        }

        @Override
        public int getWidth() {
            return this.menuCollapsed ? 20 : 110;
        }

        public void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            this.setBounds(x - this.getWidth(), y, this.getWidth(), this.group.getHeight());
        }

        public void redraw() {
            this.controls.setVisible(!this.menuCollapsed);
            this.setPosition(this.x, this.y);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == TrackGroup.this.resize) {
                this.menuCollapsed = !this.menuCollapsed;
                this.redraw();
            }
        }
    }
}

