/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Cigar;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ReadPart;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class ReadpartDataProvider {
    private Collection<RegionContent> reads = new TreeSet<RegionContent>();
    private LinkedList<ReadPart> readParts = new LinkedList();
    private LinkedList<ReadPart> readPartsF = new LinkedList();
    private LinkedList<ReadPart> readPartsR = new LinkedList();
    private boolean needsRefresh = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReads(LinkedList<RegionContent> reads) {
        LinkedList<RegionContent> linkedList = reads;
        synchronized (linkedList) {
            for (RegionContent read : reads) {
                if (!read.values.containsKey((Object)DataType.STRAND) || !read.values.containsKey((Object)DataType.SEQUENCE) || !read.values.containsKey((Object)DataType.CIGAR)) continue;
                this.reads.add(read);
                this.needsRefresh = true;
            }
        }
    }

    public Iterable<ReadPart> getReadparts(Strand strand) {
        Collection<RegionContent> collection = this.reads;
        synchronized (collection) {
            if (this.needsRefresh) {
                this.refreshReadparts();
                this.needsRefresh = false;
            }
            switch (strand) {
                case BOTH: {
                    return this.readParts;
                }
                case FORWARD: {
                    return this.readPartsF;
                }
                case REVERSE: {
                    return this.readPartsR;
                }
            }
            throw new IllegalArgumentException("illegal strand: " + (Object)((Object)strand));
        }
    }

    private void refreshReadparts() {
        this.readParts.clear();
        this.readPartsF.clear();
        this.readPartsR.clear();
        for (RegionContent read : this.reads) {
            List<ReadPart> visibleRegions = Cigar.splitElements(read);
            for (ReadPart visibleRegion : visibleRegions) {
                this.readParts.add(visibleRegion);
                if (read.values.get((Object)DataType.STRAND) == Strand.FORWARD) {
                    this.readPartsF.add(visibleRegion);
                    continue;
                }
                if (read.values.get((Object)DataType.STRAND) != Strand.REVERSE) continue;
                this.readPartsR.add(visibleRegion);
            }
        }
        Collections.sort(this.readParts);
        Collections.sort(this.readPartsF);
        Collections.sort(this.readPartsR);
    }
}

