/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.SamBamUtils;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.broad.tribble.readers.TabixReader;

public class TabixDataSource
extends DataSource {
    private TabixReader reader;

    public TabixDataSource(URL tabixFile, URL tabixIndexFile) throws URISyntaxException, IOException {
        super(tabixFile, null);
        String fileString = null;
        fileString = "http".equals(tabixFile.getProtocol()) ? tabixFile.toExternalForm() : new File(tabixFile.toURI()).getPath();
        this.reader = new TabixReader(fileString);
    }

    public void clean() {
        SamBamUtils.closeIfPossible(this.reader);
    }

    public TabixReader.Iterator getTabixIterator(Region request) {
        String chromosome = request.start.chr.toNormalisedString();
        int start = (int)Math.min(Integer.MAX_VALUE, request.start.bp);
        int end = (int)Math.min(Integer.MAX_VALUE, request.end.bp);
        int EXTRA = 500000;
        start = (int)Math.max((long)start - (long)EXTRA, 1L);
        end = (int)Math.min((long)end + (long)EXTRA, Integer.MAX_VALUE);
        int MAX_BIN_SIZE = 0x1FFFFFFE;
        start = Math.min(MAX_BIN_SIZE, start);
        end = Math.min(MAX_BIN_SIZE, end);
        start = Math.max(1, start);
        end = Math.max(1, end);
        String queryRegion = chromosome + ":" + start + "-" + end;
        TabixReader.Iterator iter = null;
        try {
            iter = this.reader.query(queryRegion);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        return iter;
    }
}

