/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.fileIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.ChromosomeNameUnnormaliser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.SamBamUtils;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import net.sf.samtools.SAMFileReader;
import net.sf.samtools.SAMRecord;
import net.sf.samtools.SAMRecordIterator;
import net.sf.samtools.SAMSequenceRecord;
import net.sf.samtools.util.CloseableIterator;

public class BamDataSource
extends DataSource {
    private ChromosomeNameUnnormaliser chromosomeNameUnnormaliser = ChromosomeNameUnnormaliser.newIdentityPreversingUnnormaliser();
    private SAMFileReader reader;

    public BamDataSource(URL samFile, URL indexFile) throws FileNotFoundException, URISyntaxException {
        super(samFile);
        PrintStream originalErr = System.err;
        System.setErr(new PrintStream(new ByteArrayOutputStream()));
        SAMFileReader.setDefaultValidationStringency((SAMFileReader.ValidationStringency)SAMFileReader.ValidationStringency.SILENT);
        this.reader = SamBamUtils.getSAMReader(samFile, indexFile);
        LinkedList<String> chrList = new LinkedList<String>();
        for (SAMSequenceRecord sequenceRecord : this.reader.getFileHeader().getSequenceDictionary().getSequences()) {
            String name = sequenceRecord.getSequenceName();
            chrList.add(name);
        }
        this.chromosomeNameUnnormaliser = new ChromosomeNameUnnormaliser(chrList);
        System.setErr(originalErr);
    }

    public void close() {
        SamBamUtils.closeIfPossible(this.reader);
    }

    public CloseableIterator<SAMRecord> query(Chromosome chr, int start, int end) {
        String unnormalisedChr = this.chromosomeNameUnnormaliser.unnormalise(chr);
        SAMRecordIterator iterator = this.reader.query(unnormalisedChr, start, end, false);
        return iterator;
    }
}

