/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.dataimport;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.HelpMapping;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.SwingClientApplication;
import fi.csc.microarray.client.dataimport.ColumnTypeManager;
import fi.csc.microarray.client.dataimport.ConversionModel;
import fi.csc.microarray.client.dataimport.ImportItem;
import fi.csc.microarray.client.dataimport.ImportScreenModel;
import fi.csc.microarray.client.dataimport.ImportSession;
import fi.csc.microarray.client.dataimport.ProgressInformator;
import fi.csc.microarray.client.dataimport.RunnableImportProcess;
import fi.csc.microarray.client.dataimport.table.InformationDialog;
import fi.csc.microarray.client.dataimport.table.TableInternalFrame;
import fi.csc.microarray.client.dataimport.tools.ToolsInternalFrame;
import fi.csc.microarray.client.dataimport.trimmer.DataTrimmer;
import fi.csc.microarray.client.screen.ScreenBase;
import fi.csc.microarray.constants.VisualConstants;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class ImportScreen
extends ScreenBase
implements ImportScreenModel,
ActionListener,
WindowListener {
    private static final int TOOLS_FRAME_WIDTH = 200;
    private static final Dimension BUTTON_SIZE = new Dimension(80, 22);
    private static final Dimension IMPORT_SCREEN_SIZE = new Dimension(850, 700);
    private static final Logger logger = Logger.getLogger(ImportScreen.class);
    private JFrame frame;
    private JSplitPane mainSplit;
    private ConversionModel conversionModel;
    private ToolsInternalFrame toolsFrame;
    private TableInternalFrame tableFrame;
    private JPanel changeStepPanel;
    private Step currentStep;
    private ColumnTypeManager columnTypeManager;
    private JButton helpButton;
    private JButton cancelButton;
    private JButton backButton;
    private JButton nextButton;
    private JButton finishButton;
    private ClientApplication application;
    private DataTrimmer dataTrimmer;
    private DataTrimmer flagTrimmer;
    private ImportSession importSession;
    private Iterator<File> files;

    public ImportScreen() {
        this.resetImportScreen(false);
        this.resetImportSession();
        SwingClientApplication.setPlastic3DLookAndFeel(this.frame);
        this.gotoFirstStep();
        this.getFrame().addWindowListener(this);
    }

    private Component getChangeStepButtonsPanel() {
        if (this.changeStepPanel == null) {
            this.changeStepPanel = new JPanel(new GridBagLayout());
            this.helpButton = new JButton("Help");
            this.cancelButton = new JButton("Cancel", VisualConstants.IMPORT_CANCEL_ICON);
            this.backButton = new JButton("Back", VisualConstants.IMPORT_BACK_ICON);
            this.nextButton = new JButton("Next", VisualConstants.IMPORT_NEXT_ICON);
            this.finishButton = new JButton("Finish", VisualConstants.IMPORT_FINISH_ICON);
            this.nextButton.setHorizontalTextPosition(10);
            this.finishButton.setHorizontalTextPosition(10);
            this.cancelButton.setHorizontalTextPosition(10);
            this.helpButton.setPreferredSize(BUTTON_SIZE);
            this.cancelButton.setPreferredSize(BUTTON_SIZE);
            this.backButton.setPreferredSize(BUTTON_SIZE);
            this.nextButton.setPreferredSize(BUTTON_SIZE);
            this.finishButton.setPreferredSize(BUTTON_SIZE);
            this.helpButton.addActionListener(this);
            this.cancelButton.addActionListener(this);
            this.backButton.addActionListener(this);
            this.nextButton.addActionListener(this);
            this.finishButton.addActionListener(this);
            GridBagConstraints c = new GridBagConstraints();
            c.weightx = 0.0;
            c.fill = 0;
            c.insets.set(10, 10, 10, 0);
            this.changeStepPanel.add((Component)this.helpButton, c);
            c.weightx = 1.0;
            c.fill = 2;
            this.changeStepPanel.add((Component)new JLabel(), c);
            c.weightx = 0.0;
            c.fill = 0;
            c.insets.set(10, 10, 10, 0);
            this.changeStepPanel.add((Component)this.backButton, c);
            this.changeStepPanel.add((Component)this.nextButton, c);
            this.changeStepPanel.add((Component)this.finishButton, c);
            c.insets.set(10, 30, 10, 10);
            this.changeStepPanel.add((Component)this.cancelButton, c);
        }
        return this.changeStepPanel;
    }

    public Step getCurrentStep() {
        return this.currentStep;
    }

    private void gotoFirstStep() {
        this.currentStep = Step.FIRST;
        this.getFrame().remove(this.tableFrame);
        this.getFrame().remove(this.toolsFrame);
        this.tableFrame.initializeFirstStep();
        this.toolsFrame.initializeFirstStep();
        this.backButton.setEnabled(false);
        this.nextButton.setEnabled(true);
        this.finishButton.setEnabled(false);
    }

    private void gotoSecondStep() {
        this.currentStep = Step.SECOND;
        this.tableFrame.initializeSecondStep();
        this.toolsFrame.initializeSecondStep();
        this.backButton.setEnabled(true);
        this.nextButton.setEnabled(false);
        this.finishButton.setEnabled(true);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == this.helpButton) {
            if (this.getCurrentStep() == Step.FIRST) {
                this.application.viewHelp(HelpMapping.MANUAL_ROOT + "import-help.html#step1");
            } else {
                this.application.viewHelp(HelpMapping.MANUAL_ROOT + "import-help.html#step2");
            }
        }
        if (source == this.backButton) {
            this.gotoFirstStep();
            this.updateTable(false);
        } else if (source == this.nextButton) {
            this.gotoSecondStep();
            this.updateTable(true);
        } else if (source == this.finishButton) {
            this.finishButtonPressed();
        } else if (source == this.cancelButton) {
            this.resetImportScreen(false);
            this.resetImportSession();
            this.gotoFirstStep();
            this.frame.setVisible(false);
        }
    }

    @Override
    public boolean hasFrame() {
        return this.frame != null;
    }

    @Override
    public JFrame getFrame() {
        return this.frame;
    }

    @Override
    public ConversionModel getConversionModel() {
        return this.conversionModel;
    }

    @Override
    public void setImportSession(ImportSession importSession) {
        this.importSession = importSession;
        this.files = importSession.getCustomFiles().iterator();
        this.conversionModel.setInputFile(this.files.next());
    }

    public void updateTable(boolean hideHeaderFooter) {
        InformationDialog infoDialog = new InformationDialog("Updating table", "", this);
        UpdateTableProcess process = new UpdateTableProcess(infoDialog, hideHeaderFooter);
        process.runProcess();
    }

    public TableInternalFrame getTableFrame() {
        return this.tableFrame;
    }

    public ToolsInternalFrame getToolsFrame() {
        return this.toolsFrame;
    }

    @Override
    public ColumnTypeManager getColumnTypeManager() {
        return this.columnTypeManager;
    }

    @Override
    public DataTrimmer getDataTrimmer() {
        return this.dataTrimmer;
    }

    @Override
    public DataTrimmer getFlagTrimmer() {
        return this.flagTrimmer;
    }

    public void resetImportScreen(boolean setVisibleAfterReset) {
        this.application = Session.getSession().getApplication();
        if (this.frame != null) {
            this.frame.setVisible(false);
        }
        this.conversionModel = new ConversionModel(this);
        this.columnTypeManager = new ColumnTypeManager(0);
        this.dataTrimmer = new DataTrimmer();
        this.dataTrimmer.addIgnoreColumnNumber(0);
        this.flagTrimmer = new DataTrimmer();
        this.flagTrimmer.addIgnoreColumnNumber(0);
        this.tableFrame = new TableInternalFrame(this);
        this.toolsFrame = new ToolsInternalFrame(this);
        this.conversionModel.addConversionChangeListener(this.tableFrame);
        this.columnTypeManager.addColumnTypeChangeListener(this.tableFrame);
        this.columnTypeManager.addColumnTypeChangeListener(this.toolsFrame);
        this.frame = new JFrame("Import tool");
        this.mainSplit = new JSplitPane();
        this.frame.setLayout(new BorderLayout());
        this.frame.setSize(IMPORT_SCREEN_SIZE);
        this.mainSplit.setOrientation(1);
        this.mainSplit.setDividerLocation(200);
        this.mainSplit.setLeftComponent(this.toolsFrame);
        this.mainSplit.setRightComponent(this.tableFrame);
        this.mainSplit.getLeftComponent().setMinimumSize(new Dimension(150, 0));
        this.mainSplit.setResizeWeight(0.0);
        this.frame.add((Component)this.mainSplit, "Center");
        this.changeStepPanel = null;
        this.frame.add(this.getChangeStepButtonsPanel(), "South");
        if (setVisibleAfterReset) {
            this.frame.setVisible(true);
        }
    }

    private void finishButtonPressed() {
        if (this.columnTypeManager.getChipCount() == 0) {
            JOptionPane.showMessageDialog(this.getFrame(), "No chips to import. Select at least one sample.", "No chips selected", 0);
        } else {
            WriteToFileProcess writeToFileProcess = new WriteToFileProcess(new InformationDialog("Writing data to disk", "Writing data to disk from file " + this.conversionModel.getInputFileName(), this));
            writeToFileProcess.runProcess();
        }
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.resetImportScreen(false);
        this.resetImportSession();
        this.gotoFirstStep();
    }

    private void resetImportSession() {
        this.importSession = null;
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    class UpdateTableProcess
    extends RunnableImportProcess {
        private boolean hideHeaderFooter;
        private Object[][] choppedDataMatrix;
        private String[] columnTitles;

        public UpdateTableProcess(ProgressInformator informator, boolean hideHeaderFooter) {
            super(informator);
            this.hideHeaderFooter = hideHeaderFooter;
        }

        @Override
        public void taskToDo() {
            logger.debug((Object)"Starting import process");
            this.choppedDataMatrix = null;
            try {
                this.choppedDataMatrix = ImportScreen.this.conversionModel.chopData(this.hideHeaderFooter, this.getInformator());
            }
            catch (IOException e) {
                ImportScreen.this.application.reportException(e);
            }
            this.columnTitles = ImportScreen.this.conversionModel.getColumnTitles();
            ImportScreen.this.tableFrame.getTable().setData(this.choppedDataMatrix, this.columnTitles);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportScreen.this.getToolsFrame().updateDelimeterPanel();
                    ImportScreen.this.getTableFrame().updateShowingColumnsLabel();
                }
            });
            logger.debug((Object)"Data set to table");
        }
    }

    class WriteToFileProcess
    extends RunnableImportProcess {
        public WriteToFileProcess(ProgressInformator informator) {
            super(informator);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void taskToDo() {
            block18: {
                File currentFile;
                block17: {
                    ArrayList<ImportItem> dataItems = new ArrayList<ImportItem>();
                    boolean hasNext = ImportScreen.this.files.hasNext();
                    currentFile = null;
                    try {
                        do {
                            ImportScreen.this.conversionModel.writeToFile(this.informator);
                            if (ImportScreen.this.application != null) {
                                for (File outputFile : ImportScreen.this.conversionModel.getOutputFiles()) {
                                    ImportItem item = new ImportItem(outputFile);
                                    item.setType(Session.getSession().getDataManager().getContentType("text/tab"));
                                    item.setFilename(outputFile.getName());
                                    dataItems.add(item);
                                }
                            }
                            if (hasNext = ImportScreen.this.files.hasNext()) {
                                currentFile = (File)ImportScreen.this.files.next();
                                ImportScreen.this.conversionModel.setInputFile(currentFile);
                            }
                            if (!hasNext) continue;
                            this.informator.setMessage("Writing data to disk from file " + currentFile.getName());
                        } while (hasNext && ImportScreen.this.importSession.getUseSameDescriptions());
                        ImportScreen.this.application.importGroup(dataItems, ImportScreen.this.importSession.getDestinationFolder());
                        if (hasNext) break block17;
                        ImportScreen.this.resetImportScreen(false);
                    }
                    catch (ClosedByInterruptException cbie) {
                        if (!hasNext) {
                            ImportScreen.this.resetImportScreen(false);
                            ImportScreen.this.resetImportSession();
                            ImportScreen.this.gotoFirstStep();
                        } else {
                            ImportScreen.this.resetImportScreen(true);
                            ImportScreen.this.conversionModel.setInputFile(currentFile);
                            ImportScreen.this.updateTable(false);
                            ImportScreen.this.gotoFirstStep();
                        }
                        break block18;
                    }
                    catch (Exception ex) {
                        if (ImportScreen.this.application != null) {
                            ImportScreen.this.application.reportException(ex);
                        } else {
                            ex.printStackTrace();
                        }
                        break block18;
                        {
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                        }
                    }
                    finally {
                        if (!hasNext) {
                            ImportScreen.this.resetImportScreen(false);
                            ImportScreen.this.resetImportSession();
                            ImportScreen.this.gotoFirstStep();
                        } else {
                            ImportScreen.this.resetImportScreen(true);
                            ImportScreen.this.conversionModel.setInputFile(currentFile);
                            ImportScreen.this.updateTable(false);
                            ImportScreen.this.gotoFirstStep();
                        }
                    }
                    ImportScreen.this.resetImportSession();
                    ImportScreen.this.gotoFirstStep();
                    break block18;
                }
                ImportScreen.this.resetImportScreen(true);
                ImportScreen.this.conversionModel.setInputFile(currentFile);
                ImportScreen.this.updateTable(false);
                ImportScreen.this.gotoFirstStep();
            }
        }
    }

    public static enum Step {
        FIRST,
        SECOND;

    }
}

