/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.shell;

import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.shell.ShellAnalysisHandler;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.filebroker.FileBrokerClientMock;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.JobMessage;
import fi.csc.microarray.messaging.message.ResultMessage;
import java.io.File;
import java.util.HashMap;
import java.util.Random;
import javax.jms.JMSException;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class ShellRoundtripTest {
    private static String path = "src/test/resources/";
    private boolean isResultOK = false;
    private ResultCallback resultCallback = new ResultCallback(){
        private FileBrokerClient fileBroker = null;

        @Override
        public FileBrokerClient getFileBrokerClient() {
            if (this.fileBroker == null) {
                try {
                    this.fileBroker = new FileBrokerClientMock();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            return this.fileBroker;
        }

        @Override
        public File getWorkDir() {
            File jobDir = new File(path, "emboss-tmp");
            if (!jobDir.exists()) {
                jobDir.mkdir();
            }
            return jobDir;
        }

        @Override
        public void removeRunningJob(AnalysisJob job) {
        }

        @Override
        public void sendResultMessage(ChipsterMessage inputMessage, ResultMessage resultMessage) {
            ShellRoundtripTest.this.isResultOK = true;
        }

        @Override
        public boolean shouldSweepWorkDir() {
            return true;
        }
    };

    @BeforeSuite
    protected void setUp() throws Exception {
        DirectoryLayout.initialiseSimpleLayout();
    }

    @Test
    public void testRoundtripExecution() throws Exception {
        JobMessage jobMessage = new JobMessage();
        jobMessage.setJobId("import-" + new Random().nextInt(1000));
        jobMessage.addParameter("1");
        jobMessage.addParameter("10");
        this.executeJob("import.sadl", jobMessage);
        Assert.assertTrue((boolean)this.isResultOK);
    }

    private void executeJob(String sadlFileName, JobMessage jobMessage) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("descriptionPath", "/opt/chipster/tools/shell");
        ShellAnalysisHandler analysisHandler = new ShellAnalysisHandler(params);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("output", "outseq");
        map.put("executable", "/opt/EMBOSS-6.2.0/emboss/seqret");
        ToolDescription description = analysisHandler.handle(null, sadlFileName, map);
        AnalysisJob analysisJob = analysisHandler.createAnalysisJob(jobMessage, description, this.resultCallback);
        analysisJob.run();
    }

    public static void main(String[] args) throws Exception {
        ShellRoundtripTest test = new ShellRoundtripTest();
        test.setUp();
        test.testRoundtripExecution();
        System.exit(0);
    }
}

