/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.camel.util.KeyValueHolder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OgnlHelper {
    private static final Pattern INDEX_PATTERN = Pattern.compile("^(.*)\\[(.*)\\]$");

    private OgnlHelper() {
    }

    public static boolean isValidOgnlExpression(String expression) {
        if (ObjectHelper.isEmpty(expression)) {
            return false;
        }
        int bracketBegin = StringHelper.countChar(expression, '[');
        int bracketEnd = StringHelper.countChar(expression, ']');
        if (bracketBegin > 0 && bracketEnd > 0) {
            return bracketBegin == bracketEnd;
        }
        return expression.contains(".");
    }

    public static boolean isInvalidValidOgnlExpression(String expression) {
        if (ObjectHelper.isEmpty(expression)) {
            return false;
        }
        if (!(expression.contains(".") || expression.contains("[") || expression.contains("]"))) {
            return false;
        }
        int bracketBegin = StringHelper.countChar(expression, '[');
        int bracketEnd = StringHelper.countChar(expression, ']');
        if (bracketBegin > 0 || bracketEnd > 0) {
            return bracketBegin != bracketEnd;
        }
        return expression.contains("..");
    }

    public static boolean isNullSafeOperator(String ognlExpression) {
        if (ObjectHelper.isEmpty(ognlExpression)) {
            return false;
        }
        return ognlExpression.startsWith("?");
    }

    public static String removeLeadingOperators(String ognlExpression) {
        if (ObjectHelper.isEmpty(ognlExpression)) {
            return ognlExpression;
        }
        if (ognlExpression.startsWith("?")) {
            ognlExpression = ognlExpression.substring(1);
        }
        if (ognlExpression.startsWith(".")) {
            ognlExpression = ognlExpression.substring(1);
        }
        return ognlExpression;
    }

    public static String removeTrailingOperators(String ognlExpression) {
        if (ObjectHelper.isEmpty(ognlExpression)) {
            return ognlExpression;
        }
        if (ognlExpression.contains("[")) {
            return ObjectHelper.before(ognlExpression, "[");
        }
        return ognlExpression;
    }

    public static String removeOperators(String ognlExpression) {
        return OgnlHelper.removeLeadingOperators(OgnlHelper.removeTrailingOperators(ognlExpression));
    }

    public static KeyValueHolder<String, String> isOgnlIndex(String ognlExpression) {
        Matcher matcher = INDEX_PATTERN.matcher(ognlExpression);
        if (matcher.matches()) {
            String value;
            String key = matcher.group(1);
            if (ObjectHelper.isEmpty(key)) {
                key = null;
            }
            if (ObjectHelper.isEmpty(value = matcher.group(2))) {
                value = null;
            }
            return new KeyValueHolder<String, String>(key, value);
        }
        return null;
    }

    public static List<String> splitOgnl(String ognl) {
        ArrayList<String> methods = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ognl.length(); ++i) {
            char ch = ognl.charAt(i);
            if (i == 0 || i == 1 && ognl.charAt(0) == '?' || ch != '.' && ch != '?') {
                sb.append(ch);
                continue;
            }
            if (ch == '.') {
                String s = sb.toString();
                sb.setLength(0);
                if (s.endsWith("?")) {
                    sb.append("?");
                    s = s.substring(0, s.length() - 1);
                }
                methods.add(s);
            }
            sb.append(ch);
        }
        if (sb.length() > 0) {
            methods.add(sb.toString());
        }
        return methods;
    }
}

