/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.LoggingExceptionHandler;
import org.apache.camel.impl.PollingConsumerSupport;
import org.apache.camel.spi.ExceptionHandler;
import org.apache.camel.util.ServiceHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventDrivenPollingConsumer
extends PollingConsumerSupport
implements Processor {
    private static final transient Log LOG = LogFactory.getLog(EventDrivenPollingConsumer.class);
    private final BlockingQueue<Exchange> queue;
    private ExceptionHandler interruptedExceptionHandler = new LoggingExceptionHandler(EventDrivenPollingConsumer.class);
    private Consumer consumer;

    public EventDrivenPollingConsumer(Endpoint endpoint) {
        this(endpoint, new ArrayBlockingQueue<Exchange>(1000));
    }

    public EventDrivenPollingConsumer(Endpoint endpoint, BlockingQueue<Exchange> queue) {
        super(endpoint);
        this.queue = queue;
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive(0L);
    }

    @Override
    public Exchange receive() {
        while (this.isRunAllowed()) {
            try {
                return this.queue.take();
            }
            catch (InterruptedException e) {
                this.handleInterruptedException(e);
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Consumer is not running, so returning null");
        }
        return null;
    }

    @Override
    public Exchange receive(long timeout) {
        try {
            return this.queue.poll(timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.handleInterruptedException(e);
            return null;
        }
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        this.queue.offer(exchange);
    }

    public ExceptionHandler getInterruptedExceptionHandler() {
        return this.interruptedExceptionHandler;
    }

    public void setInterruptedExceptionHandler(ExceptionHandler interruptedExceptionHandler) {
        this.interruptedExceptionHandler = interruptedExceptionHandler;
    }

    protected void handleInterruptedException(InterruptedException e) {
        this.getInterruptedExceptionHandler().handleException(e);
    }

    @Override
    protected void doStart() throws Exception {
        this.consumer = this.getEndpoint().createConsumer(this);
        ServiceHelper.startService(this.consumer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.consumer);
    }
}

