/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.strategy;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import org.apache.camel.Exchange;
import org.apache.camel.component.file.GenericFile;
import org.apache.camel.component.file.GenericFileEndpoint;
import org.apache.camel.component.file.GenericFileExclusiveReadLockStrategy;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.util.ExchangeHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileLockExclusiveReadLockStrategy
implements GenericFileExclusiveReadLockStrategy<File> {
    private static final transient Log LOG = LogFactory.getLog(FileLockExclusiveReadLockStrategy.class);
    private long timeout;

    @Override
    public void prepareOnStartup(GenericFileOperations<File> operations, GenericFileEndpoint<File> endpoint) {
    }

    @Override
    public boolean acquireExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        block11: {
            File target = new File(file.getAbsoluteFilePath());
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Waiting for exclusive read lock to file: " + target));
            }
            try {
                FileChannel channel = new RandomAccessFile(target, "rw").getChannel();
                boolean exclusive = false;
                StopWatch watch = new StopWatch();
                while (!exclusive) {
                    long delta;
                    if (this.timeout > 0L && (delta = watch.taken()) > this.timeout) {
                        LOG.warn((Object)("Cannot acquire read lock within " + this.timeout + " millis. Will skip the file: " + target));
                        return false;
                    }
                    FileLock lock = null;
                    try {
                        lock = this.timeout > 0L ? channel.tryLock() : channel.lock();
                    }
                    catch (IllegalStateException ex) {
                        // empty catch block
                    }
                    if (lock != null) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace((Object)("Acquired exclusive read lock: " + lock + " to file: " + target));
                        }
                        exchange.setProperty("CamelFileLock", lock);
                        exchange.setProperty("CamelFileLockName", target.getName());
                        exclusive = true;
                        continue;
                    }
                    boolean interrupted = this.sleep();
                    if (!interrupted) continue;
                    return false;
                }
            }
            catch (IOException e) {
                boolean interrupted;
                if (this.timeout == 0L) {
                    throw e;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Cannot acquire read lock. Will try again.", (Throwable)e);
                }
                if (!(interrupted = this.sleep())) break block11;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseExclusiveReadLock(GenericFileOperations<File> operations, GenericFile<File> file, Exchange exchange) throws Exception {
        FileLock lock = ExchangeHelper.getMandatoryProperty(exchange, "CamelFileLock", FileLock.class);
        String lockFileName = ExchangeHelper.getMandatoryProperty(exchange, "CamelFileLockName", String.class);
        FileChannel channel = lock.channel();
        try {
            lock.release();
        }
        finally {
            IOHelper.close(channel, "while acquiring exclusive read lock for file: " + lockFileName, LOG);
        }
    }

    private boolean sleep() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Exclusive read lock not granted. Sleeping for 1000 millis.");
        }
        try {
            Thread.sleep(1000L);
            return false;
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Sleep interrupted while waiting for exclusive read lock, so breaking out");
            }
            return true;
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

