/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui.filetree;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.filetree.RemoteDragTree;
import org.emboss.jemboss.soap.FileRoots;
import org.emboss.jemboss.soap.JembossSoapException;

public class RemoteFileTreePanel
extends JPanel {
    final Cursor cbusy = new Cursor(3);
    final Cursor cdone = new Cursor(0);
    private JComboBox rootSelect;

    public RemoteFileTreePanel(JembossParams jembossParams) throws JembossSoapException {
        this(jembossParams, true);
    }

    public RemoteFileTreePanel(final JembossParams jembossParams, boolean bl) throws JembossSoapException {
        RemoteFileTreePanel remoteFileTreePanel = this;
        this.setLayout(new BorderLayout());
        final Hashtable<String, String> hashtable = new Hashtable<String, String>();
        final FileRoots fileRoots = new FileRoots(jembossParams);
        final JPanel jPanel = new JPanel();
        final CardLayout cardLayout = new CardLayout();
        jPanel.setLayout(cardLayout);
        this.rootSelect = new JComboBox(fileRoots.getRootVector());
        int n = fileRoots.getDefaultRootIndex();
        if (n != -1) {
            this.rootSelect.setSelectedIndex(n);
        }
        Dimension dimension = this.rootSelect.getPreferredSize();
        this.rootSelect.setPreferredSize(new Dimension((int)dimension.getWidth(), (int)dimension.getHeight() - 5));
        if (bl) {
            this.add((Component)this.rootSelect, "North");
        }
        this.rootSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                fileRoots.setCurrentRoot(string);
                fileRoots.setCurrentDir(".");
                if (hashtable.containsKey(string)) {
                    cardLayout.show(jPanel, string);
                } else {
                    RemoteFileTreePanel.this.setCursor(RemoteFileTreePanel.this.cbusy);
                    RemoteDragTree remoteDragTree = new RemoteDragTree(jembossParams, fileRoots);
                    RemoteFileTreePanel.this.setCursor(RemoteFileTreePanel.this.cdone);
                    JScrollPane jScrollPane = new JScrollPane(remoteDragTree);
                    jPanel.add((Component)jScrollPane, fileRoots.getCurrentRoot());
                    hashtable.put(fileRoots.getCurrentRoot(), "yes");
                    cardLayout.show(jPanel, fileRoots.getCurrentRoot());
                }
            }
        });
        this.setCursor(this.cbusy);
        RemoteDragTree remoteDragTree = new RemoteDragTree(jembossParams, fileRoots);
        this.setCursor(this.cdone);
        JScrollPane jScrollPane = new JScrollPane(remoteDragTree);
        jPanel.add((Component)jScrollPane, fileRoots.getCurrentRoot());
        hashtable.put(fileRoots.getCurrentRoot(), "yes");
        this.setPreferredSize(new Dimension(180, 500));
        this.add((Component)jPanel, "Center");
    }

    public JComboBox getRootSelect() {
        return this.rootSelect;
    }
}

