/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class Favorites {
    private JMenuItem[] favItems = null;
    private JMenu favJMenu;

    public Favorites(JMenu jMenu) {
        this.favJMenu = jMenu;
        this.checkSavedFavorites();
        if (this.favItems == null) {
            this.defaultFavorites();
        }
    }

    private void checkSavedFavorites() {
        File file = new File(System.getProperty("user.home") + System.getProperty("file.separator") + ".jembossFavorites");
        if (!file.exists()) {
            return;
        }
        int n = 0;
        Vector<String> vector = new Vector<String>();
        String string = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string = bufferedReader.readLine()) != null) {
                string = string.trim();
                vector.add(string);
                if (string.equals("")) continue;
                ++n;
            }
            if (n < 1) {
                return;
            }
            this.favItems = new JMenuItem[n];
            n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                string = (String)vector.get(i);
                if (string.equals("")) {
                    this.favJMenu.add(new JSeparator());
                    continue;
                }
                int n2 = string.indexOf("\t");
                this.favItems[n] = new JMenuItem(string.substring(0, n2));
                this.favItems[n].setActionCommand(string.substring(n2 + 1));
                this.favJMenu.add(this.favItems[n]);
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public JMenuItem[] getFavorites() {
        return this.favItems;
    }

    protected JMenuItem add(String string, String string2) {
        JMenuItem jMenuItem = new JMenuItem(string2 + " (" + string + ")");
        jMenuItem.setActionCommand(string);
        this.favJMenu.add(jMenuItem);
        return jMenuItem;
    }

    protected void edit(String[] stringArray) {
        int n;
        Object object;
        Object object2;
        int n2;
        JPanel jPanel = new JPanel(new BorderLayout());
        final Box box = Box.createVerticalBox();
        JScrollPane jScrollPane = new JScrollPane(box);
        jScrollPane.setPreferredSize(new Dimension(500, 300));
        jPanel.add((Component)jScrollPane, "Center");
        Box box2 = Box.createHorizontalBox();
        box2.add(new JLabel("Application and Description"));
        box2.add(Box.createHorizontalGlue());
        jPanel.add((Component)box2, "North");
        int n3 = this.favJMenu.getItemCount();
        JTextField[] jTextFieldArray = new JTextField[n3];
        JComboBox[] jComboBoxArray = new JComboBox[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            JMenuItem jMenuItem = this.favJMenu.getItem(n2);
            if (jMenuItem == null || ((String)(object2 = jMenuItem.getActionCommand())).equals("ADD") || ((String)object2).equals("EDIT")) continue;
            object = Box.createHorizontalBox();
            jComboBoxArray[n2] = new JComboBox<String>(stringArray);
            jComboBoxArray[n2].setSelectedItem(object2);
            ((Container)object).add(jComboBoxArray[n2]);
            jTextFieldArray[n2] = new JTextField(jMenuItem.getText());
            Dimension dimension = jTextFieldArray[n2].getPreferredSize();
            dimension = new Dimension(200, (int)dimension.getHeight());
            jTextFieldArray[n2].setPreferredSize(dimension);
            jTextFieldArray[n2].setCaretPosition(0);
            ((Container)object).add(jTextFieldArray[n2]);
            JButton jButton = new JButton("Delete");
            jButton.addActionListener(new ActionListener((Box)object, jMenuItem){
                private final /* synthetic */ Box val$bacross;
                private final /* synthetic */ JMenuItem val$fav;
                {
                    this.val$bacross = box2;
                    this.val$fav = jMenuItem;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    box.remove(this.val$bacross);
                    box.repaint();
                    this.val$fav.setActionCommand("DELETE");
                }
            });
            ((Container)object).add(jButton);
            ((Container)object).add(Box.createHorizontalGlue());
            box.add((Component)object);
        }
        box.add(Box.createVerticalGlue());
        n2 = JOptionPane.showConfirmDialog(null, jPanel, "Edit Favourites", 2);
        if (n2 == 2) {
            return;
        }
        for (n = 0; n < n3; ++n) {
            object2 = this.favJMenu.getItem(n);
            if (object2 == null || ((String)(object = ((AbstractButton)object2).getActionCommand())).equals("ADD") || ((String)object).equals("EDIT") || ((String)object).equals("DELETE")) continue;
            ((AbstractButton)object2).setText(jTextFieldArray[n].getText());
            ((AbstractButton)object2).setActionCommand((String)jComboBoxArray[n].getSelectedItem());
        }
        for (n = n3 - 1; n != 0; --n) {
            object2 = this.favJMenu.getItem(n);
            if (object2 == null || !((String)(object = ((AbstractButton)object2).getActionCommand())).equals("DELETE")) continue;
            this.favJMenu.remove((JMenuItem)object2);
        }
    }

    private void defaultFavorites() {
        String[][] stringArrayArray = new String[][]{{"Add to Favourites", "ADD"}, {"Edit Favourites", "EDIT"}, {"Database Sequence Retrieval", "seqret"}, {"Multiple Alignments", "emma"}, {"Dotplots (exact)", "dottup"}, {"Dotplots (similar)", "dotmatcher"}, {"Primer Design", "eprimer3"}, {"Pattern Search (nucleotide)", "fuzznuc"}, {"Pattern Search (protein)", "fuzzpro"}, {"Find Reading Frames", "getorf"}, {"Best Local Alignments", "matcher"}, {"Global Alignments", "needle"}, {"Display Restriction Sites", "remap"}};
        int n = stringArrayArray.length;
        this.favItems = new JMenuItem[n];
        for (int i = 0; i < n; ++i) {
            this.favItems[i] = new JMenuItem(stringArrayArray[i][0]);
            this.favItems[i].setActionCommand(stringArrayArray[i][1]);
            this.favJMenu.add(this.favItems[i]);
            if (!this.favItems[i].getActionCommand().equals("EDIT")) continue;
            this.favJMenu.add(new JSeparator());
        }
        this.favJMenu.add(new JSeparator());
    }
}

