/*
 * Decompiled with CFR 0.152.
 */
package net.sf.picard.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class CollectionUtil {
    public static <T> List<T> makeList(T ... list) {
        ArrayList result = new ArrayList();
        Collections.addAll(result, list);
        return result;
    }

    public static <T> Set<T> makeSet(T ... list) {
        HashSet result = new HashSet();
        Collections.addAll(result, list);
        return result;
    }

    public static String join(Collection<?> items, String inBetween) {
        StringBuilder builder = new StringBuilder();
        for (Object item : items) {
            if (builder.length() > 0) {
                builder.append(inBetween);
            }
            builder.append(item);
        }
        return builder.toString();
    }

    public static class DefaultingMap<K, V>
    extends HashMap<K, V> {
        final Factory<V> defaultGenerator;
        final boolean injectValueOnDefault;

        public DefaultingMap(final V defaultValue) {
            this(new Factory<V>(){

                @Override
                public V make() {
                    return defaultValue;
                }
            }, false);
        }

        public DefaultingMap(Factory<V> defaultGenerator, boolean injectValueOnDefaulting) {
            this.defaultGenerator = defaultGenerator;
            this.injectValueOnDefault = injectValueOnDefaulting;
        }

        @Override
        public V get(Object key) {
            if (!this.containsKey(key)) {
                V val = this.defaultGenerator.make();
                if (this.injectValueOnDefault) {
                    this.put(key, val);
                }
                return val;
            }
            return super.get(key);
        }

        public static interface Factory<V> {
            public V make();
        }
    }

    public static class MultiMap<K, V>
    extends HashMap<K, Collection<V>> {
        public void append(K k, V v) {
            this.initializeKeyIfUninitialized(k);
            ((Collection)this.get(k)).add(v);
        }

        public void appendAll(K k, Collection<? extends V> v) {
            this.initializeKeyIfUninitialized(k);
            ((Collection)this.get(k)).addAll(v);
        }

        private void initializeKeyIfUninitialized(K k) {
            if (!this.containsKey(k)) {
                this.put(k, new LinkedList());
            }
        }
    }
}

