/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.soap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.MemoryComboBox;

public class ServerSetup
extends JTabbedPane {
    private MemoryComboBox publicURL;
    private MemoryComboBox privateURL;
    private MemoryComboBox publicName;
    private MemoryComboBox privateName;
    private MemoryComboBox proxyName;
    private MemoryComboBox proxyPort;
    private MemoryComboBox proxyBrowserName;
    private MemoryComboBox proxyBrowserPort;
    private JCheckBox userAuth;
    private JCheckBox useProxy;
    private JCheckBox useBrowserProxy;
    private JCheckBox callTFM;
    private JembossParams myset;

    public ServerSetup(JembossParams jembossParams) {
        this(jembossParams, true);
    }

    public ServerSetup(final JembossParams jembossParams, boolean bl) {
        Vector<String> vector;
        Vector<String> vector2;
        Serializable serializable;
        Serializable serializable2;
        Serializable serializable3;
        this.myset = jembossParams;
        GridLayout gridLayout = null;
        JPanel jPanel = null;
        JPanel jPanel2 = null;
        if (bl) {
            serializable3 = new Vector<String>();
            ((Vector)serializable3).add(this.myset.getPublicSoapURL());
            serializable2 = new Vector<String>();
            ((Vector)serializable2).add(this.myset.getPrivateSoapURL());
            serializable = new Vector<String>();
            serializable.add(this.myset.getPublicSoapService());
            vector2 = new Vector<String>();
            vector2.add(this.myset.getPrivateSoapService());
            vector = new Vector<String>();
            vector.add(this.myset.getProxyHost());
            Vector<Integer> vector3 = new Vector<Integer>();
            vector3.add(new Integer(this.myset.getProxyPortNum()));
            Vector<String> vector4 = new Vector<String>();
            vector4.add(this.myset.getBrowserProxyHost());
            Vector<Integer> vector5 = new Vector<Integer>();
            vector5.add(new Integer(this.myset.getBrowserProxyPort()));
            gridLayout = new GridLayout(7, 1, 6, 6);
            JPanel jPanel3 = new JPanel(new BorderLayout());
            jPanel = new JPanel(gridLayout);
            jPanel2 = new JPanel(gridLayout);
            JLabel jLabel = new JLabel("Public Server");
            jPanel.add(jLabel);
            this.publicURL = new MemoryComboBox((Vector)serializable3);
            jPanel2.add(this.publicURL);
            jLabel = new JLabel("Public Service Name");
            jPanel.add(jLabel);
            this.publicName = new MemoryComboBox((Vector)serializable);
            jPanel2.add(this.publicName);
            jPanel.add(new JLabel(""));
            jPanel2.add(new JLabel(""));
            jLabel = new JLabel("Private Server");
            jPanel.add(jLabel);
            this.privateURL = new MemoryComboBox((Vector)serializable2);
            jPanel2.add(this.privateURL);
            jLabel = new JLabel("Private Service Name ");
            jPanel.add(jLabel);
            this.privateName = new MemoryComboBox((Vector)vector2);
            jPanel2.add(this.privateName);
            jPanel.add(new JLabel(""));
            jPanel2.add(new JLabel(""));
            this.userAuth = new JCheckBox("User authentication required by private server", this.myset.getUseAuth());
            jPanel.add(new JLabel(""));
            jPanel2.add(this.userAuth);
            jPanel3.add((Component)jPanel, "West");
            jPanel3.add((Component)jPanel2, "Center");
            this.addTab("Servers", jPanel3);
            gridLayout = new GridLayout(7, 1, 6, 6);
            JPanel jPanel4 = new JPanel(new BorderLayout());
            this.useProxy = new JCheckBox("Use proxy settings to connect to the server", this.myset.getUseProxy());
            jPanel = new JPanel(gridLayout);
            jPanel2 = new JPanel(gridLayout);
            jPanel.add(new JLabel(""));
            jPanel2.add(new JLabel(""));
            jPanel.add(new JLabel(""));
            jPanel2.add(this.useProxy);
            jLabel = new JLabel("Proxy ");
            jPanel.add(jLabel);
            this.proxyName = new MemoryComboBox((Vector)vector);
            jPanel2.add(this.proxyName);
            jLabel = new JLabel("Proxy Port");
            jPanel.add(jLabel);
            this.proxyPort = new MemoryComboBox((Vector)vector3);
            jPanel2.add(this.proxyPort);
            this.proxyName.setEnabled(this.useProxy.isSelected());
            this.proxyPort.setEnabled(this.useProxy.isSelected());
            this.useProxy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerSetup.this.proxyName.setEnabled(ServerSetup.this.useProxy.isSelected());
                    ServerSetup.this.proxyPort.setEnabled(ServerSetup.this.useProxy.isSelected());
                    String[] stringArray = new String[]{new String("proxy.override=true")};
                    ServerSetup.this.myset.updateJembossPropStrings(stringArray);
                }
            });
            jPanel.add(new JLabel(this.myset.proxyDescription()));
            jPanel2.add(new JLabel(""));
            jPanel.add(new JLabel(""));
            jPanel2.add(new JLabel(""));
            jPanel4.add((Component)jPanel, "West");
            jPanel4.add((Component)jPanel2, "Center");
            this.addTab("Proxies", jPanel4);
            jPanel4 = new JPanel(new BorderLayout());
            gridLayout = new GridLayout(7, 1, 6, 6);
            jPanel = new JPanel(gridLayout);
            jPanel2 = new JPanel(gridLayout);
            this.useBrowserProxy = new JCheckBox("Use proxy settings for HTTP browser connection", this.myset.isBrowserProxy());
            jPanel.add(new JLabel(""));
            jPanel2.add(new JLabel(""));
            jPanel.add(new JLabel(""));
            jPanel2.add(this.useBrowserProxy);
            jLabel = new JLabel("Proxy ");
            jPanel.add(jLabel);
            this.proxyBrowserName = new MemoryComboBox((Vector)vector4);
            jPanel2.add(this.proxyBrowserName);
            jLabel = new JLabel("Proxy Port   ");
            jPanel.add(jLabel);
            this.proxyBrowserPort = new MemoryComboBox((Vector)vector5);
            jPanel2.add(this.proxyBrowserPort);
            this.proxyBrowserName.setEnabled(this.useBrowserProxy.isSelected());
            this.proxyBrowserPort.setEnabled(this.useBrowserProxy.isSelected());
            this.useBrowserProxy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerSetup.this.proxyBrowserName.setEnabled(ServerSetup.this.useBrowserProxy.isSelected());
                    ServerSetup.this.proxyBrowserPort.setEnabled(ServerSetup.this.useBrowserProxy.isSelected());
                }
            });
            this.callTFM = new JCheckBox("Get help page directly from the server");
            this.callTFM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerSetup.this.useBrowserProxy.setEnabled(!ServerSetup.this.callTFM.isSelected());
                    ServerSetup.this.proxyBrowserName.setEnabled(!ServerSetup.this.callTFM.isSelected());
                    ServerSetup.this.proxyBrowserPort.setEnabled(!ServerSetup.this.callTFM.isSelected());
                }
            });
            jPanel.add(new JLabel(""));
            jPanel2.add(this.callTFM);
            jPanel2.add(Box.createVerticalGlue());
            jPanel4.add((Component)jPanel, "West");
            jPanel4.add((Component)jPanel2, "Center");
            this.addTab("Browser Proxies", jPanel4);
        }
        gridLayout = new GridLayout(6, 1, 6, 6);
        serializable3 = new JPanel(new BorderLayout());
        jPanel = new JPanel(gridLayout);
        jPanel2 = new JPanel(gridLayout);
        jPanel.add(new JLabel("Java version  "));
        jPanel2.add(new JLabel(System.getProperty("java.version")));
        jPanel.add(new JLabel("Java home"));
        jPanel2.add(new JLabel(System.getProperty("java.home")));
        jPanel.add(new JLabel("User name "));
        jPanel2.add(new JLabel(System.getProperty("user.name")));
        jPanel.add(new JLabel("User home"));
        jPanel2.add(new JLabel(System.getProperty("user.home")));
        ((Container)serializable3).add(jPanel, "West");
        ((Container)serializable3).add(jPanel2, "Center");
        this.addTab("Client properties", (Component)serializable3);
        if (!bl) {
            serializable2 = new JPanel(new BorderLayout());
            gridLayout = new GridLayout(5, 1, 6, 6);
            jPanel = new JPanel(gridLayout);
            jPanel2 = new JPanel(gridLayout);
            this.useBrowserProxy = new JCheckBox("Use proxy settings for HTTP browser connection", this.myset.isBrowserProxy());
            jPanel.add(new JLabel(""));
            jPanel2.add(new JLabel(""));
            jPanel.add(new JLabel(""));
            jPanel2.add(this.useBrowserProxy);
            serializable = new JLabel("Proxy ");
            jPanel.add((Component)serializable);
            vector2 = new Vector();
            if (System.getProperty("http.proxyHost") != null) {
                vector2.add(System.getProperty("http.proxyHost"));
            }
            this.proxyBrowserName = new MemoryComboBox((Vector)vector2);
            jPanel2.add(this.proxyBrowserName);
            serializable = new JLabel("Proxy Port   ");
            jPanel.add((Component)serializable);
            vector = new Vector();
            if (System.getProperty("http.proxyPort") != null) {
                vector.add(System.getProperty("http.proxyPort"));
            }
            this.proxyBrowserPort = new MemoryComboBox((Vector)vector);
            jPanel2.add(this.proxyBrowserPort);
            this.proxyBrowserName.setEnabled(this.useBrowserProxy.isSelected());
            this.proxyBrowserPort.setEnabled(this.useBrowserProxy.isSelected());
            this.useBrowserProxy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ServerSetup.this.proxyBrowserName.setEnabled(ServerSetup.this.useBrowserProxy.isSelected());
                    ServerSetup.this.proxyBrowserPort.setEnabled(ServerSetup.this.useBrowserProxy.isSelected());
                    if (ServerSetup.this.useBrowserProxy.isSelected()) {
                        String[] stringArray = new String[]{new String("browserProxy.host=" + (String)ServerSetup.this.proxyBrowserName.getSelectedItem()), new String("browserProxy.port=" + (String)ServerSetup.this.proxyBrowserPort.getSelectedItem()), new String("browserProxy.use=true")};
                        jembossParams.updateJembossPropStrings(stringArray);
                    }
                }
            });
            ((Container)serializable2).add(jPanel, "West");
            ((Container)serializable2).add(jPanel2, "Center");
            this.addTab("Browser Proxies", (Component)serializable2);
        }
    }

    public JembossParams setNewSettings() {
        String[] stringArray = new String[12];
        stringArray[0] = new String("server.public=" + (String)this.publicURL.getSelectedItem());
        stringArray[1] = new String("server.private=" + (String)this.privateURL.getSelectedItem());
        stringArray[2] = new String("service.public=" + (String)this.publicName.getSelectedItem());
        stringArray[3] = new String("service.private=" + (String)this.privateName.getSelectedItem());
        stringArray[4] = this.userAuth.isSelected() ? new String("user.auth=true") : new String("user.auth=false");
        stringArray[6] = new String("proxy.host=" + (String)this.proxyName.getSelectedItem());
        stringArray[7] = new String("proxy.port=" + ((Integer)this.proxyPort.getSelectedItem()).toString());
        stringArray[5] = this.useProxy.isSelected() ? new String("proxy.use=true") : new String("proxy.use=false");
        stringArray[8] = new String("browserProxy.host=" + (String)this.proxyBrowserName.getSelectedItem());
        stringArray[9] = new String("browserProxy.port=" + ((Integer)this.proxyBrowserPort.getSelectedItem()).toString());
        stringArray[10] = this.callTFM.isSelected() ? new String("tfm.use=true") : new String("tfm.use=false");
        stringArray[11] = this.useBrowserProxy.isSelected() ? new String("browserProxy.use=true") : new String("browserProxy.use=false");
        this.myset.updateJembossPropStrings(stringArray);
        return this.myset;
    }
}

