/*
 * Decompiled with CFR 0.152.
 */
package org.emboss.jemboss.gui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import org.emboss.jemboss.Jemboss;
import org.emboss.jemboss.JembossParams;
import org.emboss.jemboss.gui.ColorMenu;
import org.emboss.jemboss.gui.ScrollPanel;
import org.emboss.jemboss.gui.SetUpMenuBar;
import org.emboss.jemboss.gui.filetree.DragTree;
import org.emboss.jemboss.gui.filetree.FileEditorDisplay;
import org.emboss.jemboss.gui.filetree.FileSave;
import org.emboss.jemboss.gui.filetree.FileSaving;
import org.emboss.jemboss.gui.filetree.LocalAndRemoteFileTreeFrame;
import org.emboss.jemboss.gui.sequenceChooser.SequenceFilter;
import org.emboss.jemboss.soap.JembossSoapException;
import org.emboss.jemboss.soap.PrivateRequest;

public class ResultsMenuBar
extends JMenuBar {
    private JMenuItem saveToLocalFile;
    private JMenuItem saveToRemoteFile;
    private JFrame frame;
    private JToolBar toolBar = new JToolBar();
    private JMenuItem undo = new JMenuItem("Undo");
    private JMenuItem redo = new JMenuItem("Redo");
    private UndoManager undoManager = new UndoManager();

    public ResultsMenuBar(JFrame jFrame, JTabbedPane jTabbedPane, Hashtable hashtable, JembossParams jembossParams) {
        this(jFrame, jTabbedPane, hashtable, null, null, jembossParams);
    }

    public ResultsMenuBar(JFrame jFrame, JTabbedPane jTabbedPane, Hashtable hashtable, Hashtable hashtable2) {
        this(jFrame, jTabbedPane, hashtable, hashtable2, null, null);
    }

    public ResultsMenuBar(JFrame jFrame, final FileEditorDisplay fileEditorDisplay, final JembossParams jembossParams) {
        this.setResultsMenuBar(jFrame, false);
        this.saveToLocalFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FileSaving fileSaving = new FileSaving(fileEditorDisplay, fileEditorDisplay.getPNGContent(), jembossParams);
                if (fileSaving.writeOK()) {
                    String string = fileSaving.getFileName();
                    String string2 = fileSaving.getPath();
                    try {
                        Jemboss.tree.addObject(string, string2, null);
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    DragTree dragTree = LocalAndRemoteFileTreeFrame.getLocalDragTree();
                    if (dragTree != null) {
                        dragTree.addObject(string, string2, null);
                    }
                }
            }
        });
        fileEditorDisplay.getDocument().addUndoableEditListener(new UndoableEditListener(){

            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                ResultsMenuBar.this.undoManager.addEdit(undoableEditEvent.getEdit());
                ResultsMenuBar.this.updateMenu();
            }
        });
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ResultsMenuBar.this.undoManager.undo();
                }
                catch (CannotRedoException cannotRedoException) {
                    cannotRedoException.printStackTrace();
                }
                ResultsMenuBar.this.updateMenu();
            }
        });
        this.redo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ResultsMenuBar.this.undoManager.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    cannotRedoException.printStackTrace();
                }
                ResultsMenuBar.this.updateMenu();
            }
        });
        JMenu jMenu = new JMenu("Colour");
        jMenu.setMnemonic(76);
        ColorMenu colorMenu = new ColorMenu("Text");
        colorMenu.setColor(fileEditorDisplay.getForeground());
        colorMenu.setMnemonic('t');
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorMenu colorMenu = (ColorMenu)actionEvent.getSource();
                fileEditorDisplay.setForeground(colorMenu.getColor());
            }
        };
        colorMenu.addActionListener(actionListener);
        jMenu.add(colorMenu);
        colorMenu = new ColorMenu("Background");
        colorMenu.setColor(fileEditorDisplay.getBackground());
        colorMenu.setMnemonic('b');
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorMenu colorMenu = (ColorMenu)actionEvent.getSource();
                fileEditorDisplay.setBackground(colorMenu.getColor());
            }
        };
        colorMenu.addActionListener(actionListener);
        jMenu.add(colorMenu);
        this.add(jMenu);
        ButtonGroup buttonGroup = new ButtonGroup();
        JMenu jMenu2 = new JMenu("Options");
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("Text");
        jMenu2.add(jRadioButtonMenuItem);
        jRadioButtonMenuItem.setSelected(true);
        buttonGroup.add(jRadioButtonMenuItem);
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem("Sequence");
        jMenu2.add(jRadioButtonMenuItem2);
        buttonGroup.add(jRadioButtonMenuItem2);
        this.add(jMenu2);
        jRadioButtonMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JRadioButtonMenuItem)actionEvent.getSource()).isSelected()) {
                    String string = fileEditorDisplay.getText();
                    fileEditorDisplay.setText("");
                    fileEditorDisplay.setText(string, "sequence");
                    fileEditorDisplay.setCaretPosition(0);
                }
            }
        });
        jRadioButtonMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (((JRadioButtonMenuItem)actionEvent.getSource()).isSelected()) {
                    String string = fileEditorDisplay.getText();
                    fileEditorDisplay.setText("");
                    fileEditorDisplay.setText(string, "regular");
                    fileEditorDisplay.setCaretPosition(0);
                }
            }
        });
        this.add(jMenu2);
        String[] stringArray = new String[]{"10", "12", "14", "16", "18"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        Font font = fileEditorDisplay.getFont();
        jComboBox.setSelectedItem(Integer.toString(font.getSize()));
        jComboBox.setPreferredSize(jComboBox.getMinimumSize());
        jComboBox.setMaximumSize(jComboBox.getMinimumSize());
        jComboBox.setEditable(true);
        this.toolBar.add(jComboBox);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Font font = fileEditorDisplay.getFont();
                try {
                    String string = (String)jComboBox.getSelectedItem();
                    if (string.indexOf(".") > -1) {
                        string = string.substring(0, string.indexOf("."));
                    }
                    font = new Font(font.getFontName(), font.getStyle(), Integer.parseInt(string));
                    fileEditorDisplay.setFont(font);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        });
        String[] stringArray2 = new String[]{"Plain", "Bold", "Italic"};
        final JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray2);
        jComboBox2.setMaximumSize(jComboBox2.getPreferredSize());
        jComboBox2.setToolTipText("Available styles");
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jComboBox2.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                Font font = fileEditorDisplay.getFont();
                font = n == 0 ? font.deriveFont(0) : (n == 1 ? font.deriveFont(1) : font.deriveFont(2));
                fileEditorDisplay.setFont(font);
            }
        });
        this.toolBar.add(jComboBox2);
    }

    public ResultsMenuBar(final JFrame jFrame, final JTabbedPane jTabbedPane, final Hashtable hashtable, final Hashtable hashtable2, final String string, final JembossParams jembossParams) {
        JComponent jComponent;
        boolean bl = false;
        if (string != null) {
            bl = true;
        }
        this.setResultsMenuBar(jFrame, bl);
        this.saveToLocalFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = "";
                String string2 = "";
                SecurityManager securityManager = System.getSecurityManager();
                System.setSecurityManager(null);
                JFileChooser jFileChooser = new JFileChooser(jembossParams.getUserHome());
                System.setSecurityManager(securityManager);
                jFileChooser.addChoosableFileFilter(new SequenceFilter());
                int n = jFileChooser.showSaveDialog(jFileChooser);
                if (n == 0) {
                    File file = jFileChooser.getSelectedFile();
                    string2 = jFileChooser.getCurrentDirectory().getAbsolutePath();
                    string = file.getName();
                    jFrame.setCursor(new Cursor(3));
                    String string3 = jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex());
                    JTextComponent jTextComponent = ResultsMenuBar.this.getJTextComponentAt(jTabbedPane, jTabbedPane.getSelectedIndex());
                    if (jTextComponent != null) {
                        ResultsMenuBar.this.fileSave(string2, string, jTextComponent.getText());
                    } else if (hashtable.containsKey(string3)) {
                        ResultsMenuBar.this.fileSave(string2, string, string3, hashtable);
                    } else if (hashtable2 != null && hashtable2.containsKey(string3)) {
                        ResultsMenuBar.this.fileSave(string2, string, string3, hashtable2);
                    }
                    jFrame.setCursor(new Cursor(0));
                }
            }
        });
        for (int i = 0; i < jTabbedPane.getTabCount(); ++i) {
            jComponent = this.getJTextComponentAt(jTabbedPane, i);
            if (jComponent == null) continue;
            ((JTextComponent)jComponent).getDocument().addUndoableEditListener(new UndoableEditListener(){

                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    ResultsMenuBar.this.undoManager.addEdit(undoableEditEvent.getEdit());
                    ResultsMenuBar.this.updateMenu();
                }
            });
        }
        this.undo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ResultsMenuBar.this.undoManager.undo();
                }
                catch (CannotRedoException cannotRedoException) {
                    cannotRedoException.printStackTrace();
                }
                ResultsMenuBar.this.updateMenu();
            }
        });
        this.redo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ResultsMenuBar.this.undoManager.redo();
                }
                catch (CannotRedoException cannotRedoException) {
                    cannotRedoException.printStackTrace();
                }
                ResultsMenuBar.this.updateMenu();
            }
        });
        JMenu jMenu = new JMenu("Colour");
        jMenu.setMnemonic(76);
        jComponent = new ColorMenu("Text");
        ((AbstractButton)jComponent).setMnemonic('t');
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorMenu colorMenu = (ColorMenu)actionEvent.getSource();
                JTextPane jTextPane = ResultsMenuBar.this.getSelectedJTextPane(jTabbedPane);
                if (jTextPane != null) {
                    jTextPane.setForeground(colorMenu.getColor());
                }
            }
        };
        ((AbstractButton)jComponent).addActionListener(actionListener);
        jMenu.add((JMenuItem)jComponent);
        jComponent = new ColorMenu("Background");
        ((AbstractButton)jComponent).setMnemonic('b');
        actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ColorMenu colorMenu = (ColorMenu)actionEvent.getSource();
                JTextPane jTextPane = ResultsMenuBar.this.getSelectedJTextPane(jTabbedPane);
                if (jTextPane != null) {
                    jTextPane.setBackground(colorMenu.getColor());
                }
            }
        };
        ((AbstractButton)jComponent).addActionListener(actionListener);
        jMenu.add((JMenuItem)jComponent);
        this.add(jMenu);
        if (bl) {
            this.saveToRemoteFile.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTextComponent jTextComponent = ResultsMenuBar.this.getJTextComponentAt(jTabbedPane, jTabbedPane.getSelectedIndex());
                    String string2 = jTabbedPane.getTitleAt(jTabbedPane.getSelectedIndex());
                    Vector<String> vector = new Vector<String>();
                    vector.addElement(string);
                    vector.addElement(string2);
                    vector.addElement(jTextComponent.getText().replace('\r', ' '));
                    try {
                        PrivateRequest privateRequest = new PrivateRequest(jembossParams, "save_project_file", vector);
                    }
                    catch (JembossSoapException jembossSoapException) {
                        // empty catch block
                    }
                }
            });
        }
        String[] stringArray = new String[]{"10", "12", "14", "16", "18"};
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray);
        jComboBox.setSelectedItem("12");
        jComboBox.setPreferredSize(jComboBox.getMinimumSize());
        jComboBox.setMaximumSize(jComboBox.getMinimumSize());
        jComboBox.setEditable(true);
        this.toolBar.add(jComboBox);
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextPane jTextPane = ResultsMenuBar.this.getSelectedJTextPane(jTabbedPane);
                if (jTextPane != null) {
                    Font font = jTextPane.getFont();
                    try {
                        String string = (String)jComboBox.getSelectedItem();
                        if (string.indexOf(".") > -1) {
                            string = string.substring(0, string.indexOf("."));
                        }
                        font = new Font("monospaced", font.getStyle(), Integer.parseInt(string));
                        jTextPane.setFont(font);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        });
        String[] stringArray2 = new String[]{"Plain", "Bold", "Italic"};
        final JComboBox<String> jComboBox2 = new JComboBox<String>(stringArray2);
        jComboBox2.setMaximumSize(jComboBox2.getPreferredSize());
        jComboBox2.setToolTipText("Available styles");
        jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = jComboBox2.getSelectedIndex();
                if (n < 0) {
                    return;
                }
                JTextPane jTextPane = ResultsMenuBar.this.getSelectedJTextPane(jTabbedPane);
                if (jTextPane == null) {
                    return;
                }
                Font font = jTextPane.getFont();
                font = n == 0 ? font.deriveFont(0) : (n == 1 ? font.deriveFont(1) : font.deriveFont(2));
                jTextPane.setFont(font);
            }
        });
        this.toolBar.add(jComboBox2);
    }

    public void setResultsMenuBar(final JFrame jFrame, boolean bl) {
        this.frame = jFrame;
        this.add(Box.createRigidArea(new Dimension(5, 24)));
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        if (bl) {
            this.saveToRemoteFile = new JMenuItem("Save to Server File");
            jMenu.add(this.saveToRemoteFile);
        }
        this.saveToLocalFile = new JMenuItem("Save to Local File...");
        jMenu.add(this.saveToLocalFile);
        jMenu.addSeparator();
        jMenu.add(this.undo);
        this.undo.setEnabled(false);
        this.undo.setAccelerator(KeyStroke.getKeyStroke(85, 2));
        jMenu.add(this.redo);
        this.redo.setEnabled(false);
        this.redo.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        jMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem("Close");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                jFrame.setVisible(false);
            }
        });
        jMenu.add(jMenuItem);
        this.add(jMenu);
        jFrame.setJMenuBar(this);
        jFrame.getContentPane().add((Component)this.toolBar, "North");
    }

    private void updateMenu() {
        this.undo.setText(this.undoManager.getUndoPresentationName());
        this.redo.setText(this.undoManager.getRedoPresentationName());
        this.undo.setEnabled(this.undoManager.canUndo());
        this.redo.setEnabled(this.undoManager.canRedo());
    }

    protected JToolBar getToolBar() {
        return this.toolBar;
    }

    private void fileSave(String string, String string2, String string3, Hashtable hashtable) {
        this.fileSave(string, string2, hashtable.get(string3));
    }

    private void fileSave(String string, String string2, Object object) {
        String string3 = new String(System.getProperty("file.separator"));
        FileSave fileSave = new FileSave(new File(string + string3 + string2));
        if (fileSave.doWrite()) {
            fileSave.fileSaving(object);
        }
        if (!fileSave.fileExists()) {
            Jemboss.tree.addObject(string2, string, null);
            DragTree dragTree = SetUpMenuBar.getLocalDragTree();
            if (dragTree != null) {
                dragTree.addObject(string2, string, null);
            }
        }
    }

    private JTextPane getSelectedJTextPane(JTabbedPane jTabbedPane) {
        try {
            JScrollPane jScrollPane = (JScrollPane)jTabbedPane.getSelectedComponent();
            return (JTextPane)jScrollPane.getViewport().getView();
        }
        catch (ClassCastException classCastException) {
            try {
                JPanel jPanel = (JPanel)jTabbedPane.getSelectedComponent();
                JScrollPane jScrollPane = (JScrollPane)jPanel.getComponent(0);
                ScrollPanel scrollPanel = (ScrollPanel)jScrollPane.getViewport().getView();
                return (JTextPane)scrollPanel.getComponent(0);
            }
            catch (ClassCastException classCastException2) {
                return null;
            }
        }
    }

    private JTextComponent getJTextComponentAt(JTabbedPane jTabbedPane, int n) {
        try {
            JScrollPane jScrollPane = (JScrollPane)jTabbedPane.getComponentAt(n);
            return (JTextComponent)jScrollPane.getViewport().getView();
        }
        catch (ClassCastException classCastException) {
            try {
                JPanel jPanel = (JPanel)jTabbedPane.getComponentAt(n);
                JScrollPane jScrollPane = (JScrollPane)jPanel.getComponent(0);
                ScrollPanel scrollPanel = (ScrollPanel)jScrollPane.getViewport().getView();
                return (JTextPane)scrollPanel.getComponent(0);
            }
            catch (ClassCastException classCastException2) {
                return null;
            }
        }
    }
}

