/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.PredicateBuilder;
import org.apache.camel.model.ExpressionSubElementDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.processor.CatchProcessor;
import org.apache.camel.spi.RouteContext;
import org.apache.camel.util.CastUtils;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@XmlRootElement(name="doCatch")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CatchDefinition
extends ProcessorDefinition<CatchDefinition> {
    @XmlElement(name="exception")
    private List<String> exceptions = new ArrayList<String>();
    @XmlElement(name="onWhen", required=false)
    private WhenDefinition onWhen;
    @XmlElement(name="handled", required=false)
    private ExpressionSubElementDefinition handled;
    @XmlElementRef
    private List<ProcessorDefinition> outputs = new ArrayList<ProcessorDefinition>();
    @XmlTransient
    private List<Class> exceptionClasses;
    @XmlTransient
    private Predicate handledPolicy;

    public CatchDefinition() {
    }

    public CatchDefinition(List<Class> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public CatchDefinition(Class exceptionType) {
        this.exceptionClasses = new ArrayList<Class>();
        this.exceptionClasses.add(exceptionType);
    }

    public String toString() {
        return "DoCatch[ " + this.getExceptionClasses() + " -> " + this.getOutputs() + "]";
    }

    @Override
    public String getShortName() {
        return "doCatch";
    }

    @Override
    public String getLabel() {
        return this.getExceptionClasses().toString();
    }

    @Override
    public CatchProcessor createProcessor(RouteContext routeContext) throws Exception {
        if (this.getExceptionClasses().isEmpty()) {
            throw new IllegalArgumentException("At least one Exception must be configured to catch");
        }
        Processor childProcessor = this.createChildProcessor(routeContext, false);
        Predicate when = null;
        if (this.onWhen != null) {
            when = this.onWhen.getExpression().createPredicate(routeContext);
        }
        Predicate handle = this.handledPolicy;
        if (this.handled != null) {
            handle = this.handled.createPredicate(routeContext);
        }
        return new CatchProcessor(this.getExceptionClasses(), childProcessor, when, handle);
    }

    @Override
    public List<ProcessorDefinition> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition> outputs) {
        this.outputs = outputs;
    }

    public List<Class> getExceptionClasses() {
        if (this.exceptionClasses == null) {
            this.exceptionClasses = this.createExceptionClasses();
        }
        return this.exceptionClasses;
    }

    public void setExceptionClasses(List<Class> exceptionClasses) {
        this.exceptionClasses = exceptionClasses;
    }

    public CatchDefinition exceptionClasses(List<Class> exceptionClasses) {
        this.setExceptionClasses(exceptionClasses);
        return this;
    }

    public CatchDefinition onWhen(Predicate predicate) {
        this.setOnWhen(new WhenDefinition(predicate));
        return this;
    }

    public ExpressionClause<CatchDefinition> onWhen() {
        this.onWhen = new WhenDefinition();
        ExpressionClause<CatchDefinition> clause = new ExpressionClause<CatchDefinition>(this);
        this.onWhen.setExpression(clause);
        return clause;
    }

    public CatchDefinition handled(boolean handled) {
        Expression expression = ExpressionBuilder.constantExpression(Boolean.toString(handled));
        return this.handled(expression);
    }

    public CatchDefinition handled(Predicate handled) {
        this.setHandledPolicy(handled);
        return this;
    }

    public CatchDefinition handled(Expression handled) {
        this.setHandledPolicy(PredicateBuilder.toPredicate(handled));
        return this;
    }

    public CatchDefinition exceptionClasses(Class exception) {
        List<Class> list = this.getExceptionClasses();
        list.add(exception);
        return this;
    }

    public List<String> getExceptions() {
        return this.exceptions;
    }

    public void setExceptions(List<String> exceptions) {
        this.exceptions = exceptions;
    }

    public WhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(WhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    public Predicate getHandledPolicy() {
        return this.handledPolicy;
    }

    public void setHandledPolicy(Predicate handledPolicy) {
        this.handledPolicy = handledPolicy;
    }

    public ExpressionSubElementDefinition getHandled() {
        return this.handled;
    }

    public void setHandled(ExpressionSubElementDefinition handled) {
        this.handled = handled;
    }

    protected List<Class> createExceptionClasses() {
        List<String> list = this.getExceptions();
        ArrayList<Class> answer = new ArrayList<Class>(list.size());
        for (String name : list) {
            Class type = CastUtils.cast(ObjectHelper.loadClass(name, this.getClass().getClassLoader()));
            answer.add(type);
        }
        return answer;
    }
}

