/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.kaha.impl.index;

import org.apache.activemq.kaha.StoreEntry;
import org.apache.activemq.kaha.impl.index.IndexItem;
import org.apache.activemq.kaha.impl.index.IndexLinkedList;

public final class VMIndexLinkedList
implements Cloneable,
IndexLinkedList {
    private transient IndexItem root;
    private transient int size;

    public VMIndexLinkedList(IndexItem header) {
        this.root.next = this.root.prev = (this.root = header);
    }

    public void setRoot(IndexItem newRoot) {
        this.root = newRoot;
    }

    public synchronized IndexItem getRoot() {
        return this.root;
    }

    public synchronized IndexItem getFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.root.next;
    }

    public synchronized IndexItem getLast() {
        if (this.size == 0) {
            return null;
        }
        return this.root.prev;
    }

    public synchronized StoreEntry removeFirst() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.root.next;
        this.remove(this.root.next);
        return result;
    }

    public synchronized Object removeLast() {
        if (this.size == 0) {
            return null;
        }
        IndexItem result = this.root.prev;
        this.remove(this.root.prev);
        return result;
    }

    public synchronized void addFirst(IndexItem item) {
        this.addBefore(item, this.root.next);
    }

    public synchronized void addLast(IndexItem item) {
        this.addBefore(item, this.root);
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public synchronized boolean add(IndexItem item) {
        this.addBefore(item, this.root);
        return true;
    }

    public synchronized void clear() {
        this.root.next = this.root.prev = this.root;
        this.size = 0;
    }

    public synchronized IndexItem get(int index) {
        return this.entry(index);
    }

    public synchronized void add(int index, IndexItem element) {
        this.addBefore(element, index == this.size ? this.root : this.entry(index));
    }

    public synchronized Object remove(int index) {
        IndexItem e = this.entry(index);
        this.remove(e);
        return e;
    }

    private IndexItem entry(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
        IndexItem e = this.root;
        if (index < this.size / 2) {
            for (int i = 0; i <= index; ++i) {
                e = e.next;
            }
        } else {
            for (int i = this.size; i > index; --i) {
                e = e.prev;
            }
        }
        return e;
    }

    public synchronized int indexOf(StoreEntry o) {
        int index = 0;
        IndexItem e = this.root.next;
        while (e != this.root) {
            if (o == e) {
                return index;
            }
            ++index;
            e = e.next;
        }
        return -1;
    }

    public synchronized IndexItem getNextEntry(IndexItem entry) {
        return entry.next != this.root ? entry.next : null;
    }

    public synchronized IndexItem getPrevEntry(IndexItem entry) {
        return entry.prev != this.root ? entry.prev : null;
    }

    public synchronized void addBefore(IndexItem insert, IndexItem e) {
        insert.next = e;
        insert.prev = e.prev;
        insert.prev.next = insert;
        insert.next.prev = insert;
        ++this.size;
    }

    public synchronized void remove(IndexItem e) {
        if (e == this.root || e.equals(this.root)) {
            return;
        }
        e.prev.next = e.next;
        e.next.prev = e.prev;
        --this.size;
    }

    public synchronized Object clone() {
        VMIndexLinkedList clone = new VMIndexLinkedList(this.root);
        IndexItem e = this.root.next;
        while (e != this.root) {
            clone.add(e);
            e = e.next;
        }
        return clone;
    }

    public synchronized StoreEntry getEntry(StoreEntry current) {
        return current;
    }

    public synchronized StoreEntry refreshEntry(StoreEntry current) {
        return current;
    }
}

