/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.config.ConfigurationLoader;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataBeanSelector;
import fi.csc.microarray.databeans.DataManager;
import fi.csc.microarray.exception.MicroarrayException;
import java.io.IOException;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.BeforeSuite;
import org.testng.annotations.Test;

public class LinkTest {
    private DataManager manager;

    @BeforeSuite(alwaysRun=true)
    public void init() throws IOException, ConfigurationLoader.IllegalConfigurationException {
        DirectoryLayout.initialiseSimpleLayout().getConfiguration();
        this.manager = new DataManager();
    }

    @Test(groups={"unit"})
    public void testLinks() throws MicroarrayException {
        DataBean bean1 = this.manager.createDataBean("test1");
        DataBean bean2 = this.manager.createDataBean("test2");
        DataBean bean3 = this.manager.createDataBean("test3");
        bean1.addLink(DataBean.Link.ANNOTATION, bean3);
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        bean1.addLink(DataBean.Link.DERIVATION, bean3);
        bean2.addLink(DataBean.Link.DERIVATION, bean3);
        Assert.assertEquals((int)bean1.getLinkTargets(DataBean.Link.DERIVATION).size(), (int)2);
        Assert.assertEquals((int)bean1.getLinkSources(DataBean.Link.DERIVATION).size(), (int)0);
        Assert.assertEquals((int)bean2.getLinkTargets(DataBean.Link.DERIVATION).size(), (int)1);
        Assert.assertEquals((int)bean2.getLinkSources(DataBean.Link.DERIVATION).size(), (int)1);
        Assert.assertEquals((int)bean3.getLinkTargets(DataBean.Link.DERIVATION).size(), (int)0);
        Assert.assertEquals((int)bean3.getLinkSources(DataBean.Link.DERIVATION).size(), (int)2);
        bean1.removeLink(DataBean.Link.DERIVATION, bean3);
        Assert.assertEquals((int)bean1.getLinkTargets(DataBean.Link.DERIVATION).size(), (int)1);
        Assert.assertEquals((int)bean1.getLinkSources(DataBean.Link.DERIVATION).size(), (int)0);
        Assert.assertEquals((int)bean2.getLinkTargets(DataBean.Link.DERIVATION).size(), (int)1);
        Assert.assertEquals((int)bean2.getLinkSources(DataBean.Link.DERIVATION).size(), (int)1);
        Assert.assertEquals((int)bean3.getLinkTargets(DataBean.Link.DERIVATION).size(), (int)0);
        Assert.assertEquals((int)bean3.getLinkSources(DataBean.Link.DERIVATION).size(), (int)1);
        Assert.assertEquals((int)bean1.getLinkTargets(DataBean.Link.ANNOTATION).size(), (int)1);
        Assert.assertEquals((int)bean1.getLinkSources(DataBean.Link.ANNOTATION).size(), (int)0);
        Assert.assertEquals((int)bean2.getLinkTargets(DataBean.Link.ANNOTATION).size(), (int)0);
        Assert.assertEquals((int)bean2.getLinkSources(DataBean.Link.ANNOTATION).size(), (int)0);
        Assert.assertEquals((int)bean3.getLinkTargets(DataBean.Link.ANNOTATION).size(), (int)0);
        Assert.assertEquals((int)bean3.getLinkSources(DataBean.Link.ANNOTATION).size(), (int)1);
    }

    @Test(groups={"unit"})
    public void testTraversal() throws MicroarrayException {
        DataBean bean1 = this.manager.createDataBean("test1");
        final DataBean bean2 = this.manager.createDataBean("test2");
        DataBean bean3 = this.manager.createDataBean("test3");
        bean1.addLink(DataBean.Link.DERIVATION, bean2);
        bean1.addLink(DataBean.Link.DERIVATION, bean3);
        bean2.addLink(DataBean.Link.DERIVATION, bean3);
        Assert.assertTrue((bean1.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.DIRECT).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((bean1.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.REVERSED).size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((bean1.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.BIDIRECTIONAL).size() == 3 ? 1 : 0) != 0);
        Assert.assertTrue((bean2.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.DIRECT).size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)bean2.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.REVERSED).contains(bean1));
        Assert.assertTrue((bean2.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.BIDIRECTIONAL).size() == 3 ? 1 : 0) != 0);
        List<DataBean> selected = bean2.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.BIDIRECTIONAL, new DataBeanSelector(){

            @Override
            public boolean shouldSelect(DataBean bean) {
                return bean == bean2;
            }

            @Override
            public boolean shouldTraverse(DataBean bean) {
                return true;
            }
        });
        Assert.assertTrue((selected.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)selected.contains(bean2));
    }
}

