/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class StatusTitleTrack
extends Track {
    private static final long VISIBLE_AFTER = 100L;
    private Color color;
    private String title;
    private Color bgColor;
    private Map<DataThread, Long> queueLengths = new HashMap<DataThread, Long>();
    private double angle;
    private long previousTime;
    private long hideTime = 0L;

    public StatusTitleTrack(String title, Color color) {
        this.color = color;
        this.title = title;
        this.layoutHeight = 10;
    }

    public StatusTitleTrack(String title, Color color, Color bgColor) {
        this(title, color);
        this.bgColor = bgColor;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        long queueLength;
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.bgColor != null) {
            drawables.add(new RectDrawable(0, 0, this.view.getWidth(), this.getHeight(), this.bgColor, this.bgColor));
        }
        if ((queueLength = this.getMaxQueueLength()) > 0L) {
            if (System.currentTimeMillis() - this.hideTime > 100L) {
                for (double d = 0.0; d < 1.0; d += 0.1) {
                    int x = (int)(Math.sin(this.angle + d * Math.PI * 1.5) * 4.0);
                    int y = (int)(Math.cos(this.angle + d * Math.PI * 1.5) * 4.0);
                    this.angle += 0.005 * (double)(System.currentTimeMillis() - this.previousTime);
                    this.previousTime = System.currentTimeMillis();
                    if (this.angle < 0.0) {
                        this.angle += Math.PI * 2;
                    }
                    Color c = GBrowserConstants.COLOR_BLUE;
                    c = new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(d * 128.0));
                    drawables.add(new RectDrawable(new Rectangle(x + 4, y + 3, 3, 3), c, c));
                    this.view.redraw();
                }
            }
        } else {
            this.hideTime = System.currentTimeMillis();
        }
        drawables.add(new TextDrawable(13, 10, this.title, this.color));
        return drawables;
    }

    private long getMaxQueueLength() {
        long max = 0L;
        for (Long value : this.queueLengths.values()) {
            max = Math.max(max, value);
        }
        return max;
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        DataThread dataThread = dataResult.getStatus().getDataThread();
        if (dataResult.getStatus().getDataRequestCount() >= 0L) {
            if (!this.queueLengths.containsKey(dataThread)) {
                this.queueLengths.put(dataThread, 0L);
            }
            Long value = dataResult.getStatus().getDataRequestCount();
            this.queueLengths.put(dataThread, value);
        }
    }

    @Override
    public int getHeight() {
        return 10;
    }

    @Override
    public String getName() {
        return "title";
    }
}

