/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserConstants;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.GBrowserView;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Strand;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageAverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageEstimateTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.CoverageTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.DensityGraphTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReadPileTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.ReferenceSequenceTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.SeparatorTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.StatusTitleTrack;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.TrackGroup;
import java.awt.Color;

public class ReadTrackGroup
extends TrackGroup {
    private final Color fontColor = Color.black;
    protected StatusTitleTrack titleTrack;
    protected CoverageEstimateTrack coverageEstimate;
    protected ReadPileTrack readPileForward;
    protected ReferenceSequenceTrack referenceSequence;
    protected ReadPileTrack readsReverse;
    protected CoverageTrack coverageTrack;
    protected CoverageAverageTrack coverageAverageTrack;
    protected DensityGraphTrack densityGraph;
    protected SeparatorTrack separatorReadPile;
    protected SeparatorTrack separatorReferenceSequence;
    protected SeparatorTrack separatorDensity;
    protected SeparatorTrack separatorQualityCoverage;
    protected SeparatorTrack sepTrackGel;
    protected SeparatorTrack separatorCoverageEstimate;
    private DataThread referenceSequenceFile;
    private DataThread details;
    private DataThread coverage;
    private DataThread estimate;
    private String title;
    private boolean initialised = false;

    public ReadTrackGroup(GBrowserView view, DataThread details, DataThread coverage, DataThread estimate, DataThread seqFile, String title) {
        super(view);
        this.details = details;
        this.coverage = coverage;
        this.estimate = estimate;
        this.referenceSequenceFile = seqFile;
        this.title = title;
    }

    public void initialise() {
        this.titleTrack = new StatusTitleTrack(this.title, Color.black);
        this.titleTrack.setView(this.view);
        this.tracks.add(this.titleTrack);
        if (this.details != null) {
            this.readPileForward = new ReadPileTrack(this.referenceSequenceFile, this.fontColor);
            this.readPileForward.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.readPileForward.setView(this.view);
            this.readPileForward.addDataThread(this.details);
            this.tracks.add(this.readPileForward);
            this.separatorReadPile = new SeparatorTrack(Color.gray, 1);
            this.separatorReadPile.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.separatorReadPile.setView(this.view);
            this.separatorReadPile.setName("Reads");
            this.tracks.add(this.separatorReadPile);
            this.titleTrack.addDataThread(this.details);
        }
        if (this.referenceSequenceFile != null) {
            this.referenceSequence = new ReferenceSequenceTrack();
            this.referenceSequence.setViewLimits(0L, GBrowserConstants.SHOW_REFERENCE_AT);
            this.referenceSequence.setView(this.view);
            this.referenceSequence.addDataThread(this.referenceSequenceFile);
            this.tracks.add(this.referenceSequence);
            this.separatorReferenceSequence = new SeparatorTrack(Color.gray, 1);
            this.separatorReferenceSequence.setViewLimits(0L, GBrowserConstants.SHOW_REFERENCE_AT);
            this.separatorReferenceSequence.setView(this.view);
            this.separatorReferenceSequence.setName("Reads");
            this.tracks.add(this.separatorReferenceSequence);
            this.titleTrack.addDataThread(this.referenceSequenceFile);
        }
        if (this.details != null) {
            this.addCoverageEstimate();
            this.readsReverse = new ReadPileTrack(this.referenceSequenceFile, this.fontColor);
            this.readsReverse.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.readsReverse.setView(this.view);
            this.readsReverse.addDataThread(this.details);
            this.readsReverse.setStrand(Strand.REVERSE);
            this.tracks.add(this.readsReverse);
            SeparatorTrack sepTrackReads2 = new SeparatorTrack(Color.gray, 1);
            sepTrackReads2.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            sepTrackReads2.setView(this.view);
            sepTrackReads2.setName("Reads");
            this.tracks.add(sepTrackReads2);
            this.coverageTrack = new CoverageTrack(this.coverage, this.referenceSequenceFile);
            this.coverageTrack.setViewLimits(0L, GBrowserConstants.SHOW_AVERAGES);
            this.coverageTrack.setView(this.view);
            this.coverageTrack.setName("Coverage");
            this.tracks.add(this.coverageTrack);
            this.coverageAverageTrack = new CoverageAverageTrack();
            this.coverageAverageTrack.setViewLimits(GBrowserConstants.SHOW_AVERAGES, GBrowserConstants.SWITCH_VIEWS_AT);
            this.coverageAverageTrack.addDataThread(this.coverage);
            this.coverageAverageTrack.setView(this.view);
            this.coverageAverageTrack.setName("Coverage");
            this.tracks.add(this.coverageAverageTrack);
            this.titleTrack.addDataThread(this.coverage);
            this.separatorDensity = new SeparatorTrack(Color.gray, 1);
            this.separatorDensity.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.separatorDensity.setView(this.view);
            this.separatorDensity.setName("DensityGraphTrack");
            this.tracks.add(this.separatorDensity);
            this.densityGraph = new DensityGraphTrack(Color.WHITE);
            this.densityGraph.setViewLimits(0L, GBrowserConstants.SWITCH_VIEWS_AT);
            this.densityGraph.setView(this.view);
            this.densityGraph.addDataThread(this.coverage);
            this.tracks.add(this.densityGraph);
        }
        this.initialised = true;
    }

    protected void addCoverageEstimate() {
        this.coverageEstimate = new CoverageEstimateTrack();
        this.coverageEstimate.setViewLimits(GBrowserConstants.SWITCH_VIEWS_AT, Long.MAX_VALUE);
        this.coverageEstimate.setView(this.view);
        this.coverageEstimate.addDataThread(this.estimate);
        this.coverageEstimate.setName("CoverageEstimate");
        this.tracks.add(this.coverageEstimate);
        this.titleTrack.addDataThread(this.estimate);
    }

    public void setVisibleSNP(boolean b) {
        this.check();
        if (b) {
            this.readPileForward.enableSNPHighlight();
            this.readsReverse.enableSNPHighlight();
            this.coverageTrack.enableSNPHighlight();
        } else {
            this.readPileForward.disableSNPHiglight();
            this.readsReverse.disableSNPHiglight();
            this.coverageTrack.disableSNPHighlight();
        }
        this.view.fireDataRequests();
        this.view.redraw();
    }

    public void setStrandSpecificCoverageType(boolean b) {
        this.check();
        this.coverageEstimate.setStrandSpecificCoverageType(b);
        this.coverageAverageTrack.setStrandSpecificCoverageType(b);
        this.coverageTrack.setStrandSpecificCoverageType(b);
        this.view.redraw();
    }

    @Override
    public String getName() {
        this.check();
        return "Read Track Group";
    }

    @Override
    public void showOrHide(String name, boolean state) {
        this.check();
        super.showOrHide(name, state);
        if (name.equals("highlightSNP")) {
            this.setVisibleSNP(state);
        } else if (name.equals("StrandSpecificCoverageType")) {
            this.setStrandSpecificCoverageType(state);
        }
    }

    private void check() {
        if (!this.initialised) {
            throw new IllegalStateException("you must call initialise() after creating this object");
        }
    }
}

