/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex;

import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.BinarySearchIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.GtfLineParser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.InMemoryIndex;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.RandomAccessLineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;

public class IndexPerformanceTest {
    public static void main(String[] args) throws FileNotFoundException, MalformedURLException, IOException, URISyntaxException, GBrowserException {
        IndexPerformanceTest.printMemoryUsage();
        long t = System.currentTimeMillis();
        File file = new File(System.getProperty("user.home") + "/chipster/Homo_sapiens.GRCh37.69-sort.gtf");
        InMemoryIndex memIndex = new InMemoryIndex(new LineDataSource(file.toURI().toURL()), new GtfLineParser());
        System.out.println("Init memIndex: " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        IndexPerformanceTest.printMemoryUsage();
        BinarySearchIndex searchIndex = new BinarySearchIndex(new RandomAccessLineDataSource(file.toURI().toURL()), new GtfLineParser());
        System.out.println("Init  searchIndex: " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        IndexPerformanceTest.printMemoryUsage();
        Region chr1 = new Region(0L, 100000000L, new Chromosome("1"));
        System.out.println("Troughput test");
        IndexPerformanceTest.troughputTest("memIndex:    ", memIndex, chr1);
        IndexPerformanceTest.troughputTest("searchIndex: ", searchIndex, chr1);
        System.out.println("Random access test");
        IndexPerformanceTest.seekTest("memIndex:    ", memIndex);
        IndexPerformanceTest.seekTest("searchIndex: ", searchIndex);
        System.out.println("Agreement test");
        IndexPerformanceTest.agreementTest(memIndex, searchIndex);
    }

    private static void troughputTest(String description, Index index, Region chr1) throws IOException, GBrowserException {
        long t = System.currentTimeMillis();
        long bytes = 0L;
        for (String line : index.getFileLines(chr1).values()) {
            bytes += (long)(line.length() + 1);
        }
        long dt = System.currentTimeMillis() - t;
        System.out.println(description + " \tBytes: " + bytes / 1024L / 1024L + " MB \tTime: " + dt + " ms \tBandwidth: " + (double)bytes / 1024.0 / 1024.0 / ((double)dt / 1000.0) + "MB/s");
    }

    private static void seekTest(String description, Index index) throws IOException, GBrowserException {
        long t = System.currentTimeMillis();
        IndexPerformanceTest.randomSeeks(index);
        System.out.println(description + " Seek 1000, first: " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        IndexPerformanceTest.printMemoryUsage();
        IndexPerformanceTest.randomSeeks(index);
        System.out.println(description + "Seek 1000, second: " + (System.currentTimeMillis() - t) + " ms");
        t = System.currentTimeMillis();
        IndexPerformanceTest.printMemoryUsage();
    }

    private static Random randomSeeks(Index index) throws IOException, GBrowserException {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            Chromosome chr = new Chromosome("" + rand.nextInt(22));
            long start = rand.nextInt(200000000);
            long end = start + 100000L;
            Region region = new Region(start, end, chr);
            index.getFileLines(region);
        }
        return rand;
    }

    private static void agreementTest(InMemoryIndex index1, BinarySearchIndex index2) throws IOException, GBrowserException {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            Collection<String> lines2;
            Chromosome chr = new Chromosome("" + rand.nextInt(22));
            long start = rand.nextInt(200000000);
            long end = start + 100000L;
            Region region = new Region(start, end, chr);
            Collection<String> lines1 = index1.getFileLines(region).values();
            if (IndexPerformanceTest.testCompare(lines1, lines2 = index2.getFileLines(region).values())) continue;
            System.err.println("\tRequest region: " + region);
        }
        System.out.println("Agreement test done");
    }

    private static boolean testCompare(Collection<String> lines1, Collection<String> lines2) {
        if (lines1.size() != lines2.size()) {
            System.err.println("Unequal line count: " + lines1.size() + ", " + lines2.size());
        }
        Iterator<String> iter1 = lines1.iterator();
        Iterator<String> iter2 = lines2.iterator();
        while (iter1.hasNext()) {
            String line2;
            String line1 = iter1.next();
            if (line1.equals(line2 = iter2.next())) continue;
            System.err.println("Unequal lines");
            System.err.println("\t" + line1);
            System.err.println("\t" + line2);
            return false;
        }
        return true;
    }

    private static void printMemoryUsage() {
        Runtime rt = Runtime.getRuntime();
        System.out.println("Memory usage: " + (rt.totalMemory() - rt.freeMemory()) / 1024L / 1024L + " MB");
    }
}

