/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.gui;

import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.QueueManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.DataResultListener;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.GeneResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.runtimeIndex.DataThread;
import java.util.HashMap;
import java.util.Map;

public class GeneIndexActions
implements DataResultListener {
    private QueueManager queueManager;
    private DataThread gtfDataSource;
    private DataThread geneDataSource;
    private Map<String, GeneLocationListener> listenerMap = new HashMap<String, GeneLocationListener>();

    public GeneIndexActions(QueueManager queueManager, DataThread gtfDataSource, DataThread geneDataSource) {
        this.queueManager = queueManager;
        this.gtfDataSource = gtfDataSource;
        this.geneDataSource = geneDataSource;
        queueManager.addDataResultListener(gtfDataSource, this);
        queueManager.addDataResultListener(geneDataSource, this);
    }

    public void requestLocation(String gene, GeneLocationListener listener) {
        this.listenerMap.put(gene, listener);
        this.queueManager.addDataRequest(this.geneDataSource, new GeneRequest(gene, null), null);
    }

    private void requestLocation(String gene, Chromosome chr) {
        this.queueManager.addDataRequest(this.gtfDataSource, new GeneRequest(gene, chr), null);
    }

    public static boolean checkIfNumber(String name) {
        try {
            Integer.parseInt(name);
            return true;
        }
        catch (NumberFormatException e) {
            try {
                Long.parseLong(name);
                return true;
            }
            catch (NumberFormatException e1) {
                return false;
            }
        }
    }

    @Override
    public void processDataResult(DataResult dataResult) {
        if (dataResult instanceof GeneResult) {
            GeneResult geneResult = (GeneResult)dataResult;
            if (geneResult.getGeneLocation() == null) {
                this.listenerMap.get(geneResult.getSearchString()).geneLocation(geneResult.getGeneLocation());
                this.listenerMap.remove(geneResult.getSearchString());
            } else if (geneResult.getGeneLocation().start.bp != null) {
                this.listenerMap.get(geneResult.getSearchString()).geneLocation(geneResult.getGeneLocation());
                this.listenerMap.remove(geneResult.getSearchString());
            } else {
                this.requestLocation(geneResult.getSearchString(), geneResult.getGeneLocation().start.chr);
            }
        }
    }

    public static interface GeneLocationListener {
        public void geneLocation(Region var1);
    }
}

