/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods;

import fi.csc.microarray.client.ClientApplication;
import fi.csc.microarray.client.Session;
import fi.csc.microarray.client.dialog.ChipsterDialog;
import fi.csc.microarray.client.dialog.DialogInfo;
import fi.csc.microarray.client.selection.IntegratedEntity;
import fi.csc.microarray.client.selection.PointSelectionEvent;
import fi.csc.microarray.client.visualisation.Visualisation;
import fi.csc.microarray.client.visualisation.VisualisationFrame;
import fi.csc.microarray.client.visualisation.VisualisationFrameManager;
import fi.csc.microarray.client.visualisation.VisualisationMethod;
import fi.csc.microarray.client.visualisation.methods.gbrowser.GBrowser;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.AnnotationManager;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.DataUrl;
import fi.csc.microarray.client.visualisation.methods.gbrowser.gui.Interpretation;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.VisualConstants;
import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.exception.MicroarrayException;
import fi.csc.microarray.filebroker.FileBrokerClient;
import fi.csc.microarray.module.chipster.MicroarrayModule;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class ChipsterGBrowserVisualisation
extends Visualisation {
    private static final String ANNOTATIONS_PATH = "annotations";
    private ChipsterGBrowser browser;
    private final ClientApplication application = Session.getSession().getApplication();

    @Override
    public void initialise(VisualisationFrame frame) throws Exception {
        super.initialise(frame);
        this.browser = new ChipsterGBrowser();
        this.browser.initialise();
    }

    @Override
    public JComponent getVisualisation(DataBean data) throws Exception {
        return this.getVisualisation(Arrays.asList(data));
    }

    @Override
    public JComponent getVisualisation(List<DataBean> datas) throws Exception {
        List<Interpretation> interpretations = this.interpretUserDatas(datas);
        if (interpretations != null) {
            return this.browser.getVisualisation(interpretations);
        }
        return null;
    }

    private boolean isIndexData(DataBean bean) {
        return bean.getName().endsWith(".bai");
    }

    @Override
    public boolean canVisualise(DataBean data) throws MicroarrayException {
        return this.canVisualise(Arrays.asList(data));
    }

    @Override
    public boolean canVisualise(List<DataBean> datas) throws MicroarrayException {
        return this.interpretUserDatas(datas) != null;
    }

    private List<Interpretation> interpretUserDatas(List<DataBean> datas) {
        LinkedList<Interpretation> interpretations = new LinkedList<Interpretation>();
        for (DataBean data : datas) {
            if (data.isContentTypeCompatitible("text/bed")) {
                interpretations.add(new DataBeanInterpretation(Interpretation.TrackType.REGIONS, new BeanDataFile(data)));
                continue;
            }
            if (data.isContentTypeCompatitible("application/bam")) {
                interpretations.add(new DataBeanInterpretation(Interpretation.TrackType.READS, new BeanDataFile(data)));
                continue;
            }
            if (data.isContentTypeCompatitible("text/vcf")) {
                interpretations.add(new DataBeanInterpretation(Interpretation.TrackType.VCF, new BeanDataFile(data)));
                continue;
            }
            if (data.isContentTypeCompatitible("text/gtf")) {
                interpretations.add(new DataBeanInterpretation(Interpretation.TrackType.GTF, new BeanDataFile(data)));
                continue;
            }
            if (!data.isContentTypeCompatitible("text/tab") || !data.hasTypeTag(MicroarrayModule.TypeTags.CHROMOSOME_IN_SECOND_TABLE_COLUMN) || !data.hasTypeTag(MicroarrayModule.TypeTags.START_POSITION_IN_THIRD_TABLE_COLUMN) || !data.hasTypeTag(MicroarrayModule.TypeTags.END_POSITION_IN_FOURTH_TABLE_COLUMN)) continue;
            DataBeanInterpretation freqs = new DataBeanInterpretation(Interpretation.TrackType.CNA_FREQUENCIES, new BeanDataFile(data, data.getName()));
            freqs.setName(data.getName() + " frequencies");
            interpretations.add(freqs);
            DataBeanInterpretation calls = new DataBeanInterpretation(Interpretation.TrackType.CNA_CALLS, new BeanDataFile(data, data.getName()));
            calls.setName(data.getName() + " calls");
            interpretations.add(calls);
            DataBeanInterpretation logratios = new DataBeanInterpretation(Interpretation.TrackType.CNA_LOGRATIOS, new BeanDataFile(data, data.getName()));
            logratios.setName(data.getName() + " log ratios");
            interpretations.add(logratios);
        }
        for (DataBean data : datas) {
            Interpretation primaryInterpretation = null;
            for (Interpretation interpretation : interpretations) {
                if (!data.getName().startsWith(interpretation.getPrimaryData().getName())) continue;
                primaryInterpretation = interpretation;
                break;
            }
            if (primaryInterpretation == null) {
                return null;
            }
            if (!data.isContentTypeCompatitible("application/octet-stream") || !this.isIndexData(data)) continue;
            if (primaryInterpretation.getIndexData() != null) {
                return null;
            }
            primaryInterpretation.setIndexData(new BeanDataFile(data));
        }
        for (Interpretation interpretation : interpretations) {
            if (!interpretation.getPrimaryData().getName().endsWith(".bam") || interpretation.getIndexData() != null) continue;
            String indexName = interpretation.getPrimaryData().getName().replace(".bam", ".bam.bai");
            LinkedList<DataBean> beanList = this.application.getDataManager().getDataBeans(indexName);
            if (beanList.size() == 1) {
                DataBean indexBean = beanList.get(0);
                interpretation.setIndexData(new BeanDataFile(indexBean));
                continue;
            }
            if (beanList.size() > 1) {
                if (this.browser == null) continue;
                this.browser.showDialog("Unable to determine index file", "There are several index files with name '" + indexName + "'. " + "Please identify the right index file by selecting it or rename bam and bai file pairs with unique names.", null, false, false, true, true);
                return null;
            }
            if (this.browser != null) {
                this.browser.showDialog("Missing index file", "There is no index file for data '" + interpretation.getPrimaryData().getName() + "'.", null, false, false, true, true);
            }
            return null;
        }
        return interpretations;
    }

    @Override
    public boolean isForSingleData() {
        return true;
    }

    @Override
    public boolean isForMultipleDatas() {
        return true;
    }

    @Override
    public void removeVisualisation() {
        super.removeVisualisation();
        this.browser.removeVisualisation();
        this.application.removeClientEventListener(this.browser);
    }

    @Override
    public JPanel getParameterPanel() {
        return this.browser.getParameterPanel();
    }

    public class ObjVariable
    extends Visualisation.Variable {
        public Object obj;

        public ObjVariable(Object obj) {
            super(null, null);
            this.obj = obj;
        }
    }

    private static class ChipsterGBrowser
    extends GBrowser
    implements PropertyChangeListener {
        private ClientApplication application = Session.getSession().getApplication();

        @Override
        public void reportException(Exception e) {
            this.application.reportException(e);
        }

        @Override
        public void showDialog(String title, String message, String details, boolean warning, boolean dialogShowDetails, boolean modal, boolean closeBrowser) {
            DialogInfo.Severity severity = warning ? DialogInfo.Severity.WARNING : DialogInfo.Severity.INFO;
            ChipsterDialog.DetailsVisibility detailsVisibility = dialogShowDetails ? ChipsterDialog.DetailsVisibility.DETAILS_VISIBLE : ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN;
            this.application.showDialog(title, message, details, severity, modal, detailsVisibility, null);
            if (closeBrowser) {
                this.application.setVisualisationMethod(VisualisationMethod.NONE, null, this.application.getSelectionManager().getSelectedDataBeans(), VisualisationFrameManager.FrameType.MAIN);
            }
        }

        @Override
        public void showVisualisation() {
            super.showVisualisation();
            this.application.removeClientEventListener(this);
            this.application.addClientEventListener(this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            IntegratedEntity sel;
            if (event instanceof PointSelectionEvent && (sel = this.application.getSelectionManager().getSelectionManager(null).getPointSelection()).containsKey("chromosome") && sel.containsKey("start")) {
                Chromosome chr = new Chromosome((String)sel.get("chromosome"));
                Long start = Long.parseLong((String)sel.get("start"));
                Long end = sel.containsKey("end") ? Long.valueOf(Long.parseLong((String)sel.get("end"))) : null;
                this.setLocation(chr, start, end);
            }
        }

        @Override
        public void runBlockingTask(String taskName, Runnable runnable) {
            this.application.runBlockingTask(taskName, runnable);
        }

        @Override
        public void initialiseUserDatas() throws IOException {
            for (Interpretation interpretation : this.getInterpretations()) {
                this.initialiseUserData(interpretation.getPrimaryData());
                this.initialiseUserData(interpretation.getIndexData());
            }
        }

        protected void initialiseUserData(DataUrl data) throws IOException {
            if (data != null) {
                try {
                    data.getLocalFile();
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public ImageIcon getIcon(String path) {
            return new ImageIcon(VisualConstants.class.getResource(path));
        }

        @Override
        public void openDownloadAnnotationsDialog(final AnnotationManager.Genome genome) {
            Session.getSession().getApplication().showDialog("Download annotations for " + genome + "?", "Downloading annotations is highly recommended to get optimal performace with genome browser.\n\nYou only need to download annotations once, after that they are stored on your local computer for further use.", "", DialogInfo.Severity.INFO, true, ChipsterDialog.DetailsVisibility.DETAILS_ALWAYS_HIDDEN, new ChipsterDialog.PluginButton(){

                @Override
                public void actionPerformed() {
                    try {
                        ChipsterGBrowser.this.getAnnotationManager().downloadAnnotations(genome);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }

                @Override
                public String getText() {
                    return "Download ";
                }
            });
        }

        @Override
        @Deprecated
        public URL getRemoteAnnotationsUrl() throws Exception {
            FileBrokerClient fileBroker = Session.getSession().getServiceAccessor().getFileBrokerClient();
            List<URL> publicFiles = fileBroker.getPublicFiles();
            if (publicFiles != null) {
                for (URL url : publicFiles) {
                    if (!url.getPath().contains("/annotations")) continue;
                    String urlString = url.toString();
                    String annotationString = urlString.substring(0, urlString.indexOf("/annotations") + ChipsterGBrowserVisualisation.ANNOTATIONS_PATH.length() + 1);
                    return new URL(annotationString);
                }
            }
            return null;
        }

        @Override
        public List<URL> getRemoteAnnotationFiles() throws Exception {
            FileBrokerClient fileBroker = Session.getSession().getServiceAccessor().getFileBrokerClient();
            return fileBroker.getPublicFiles();
        }

        @Override
        public File getLocalAnnotationDir() throws IOException {
            return DirectoryLayout.getInstance().getLocalAnnotationDir();
        }

        @Override
        public LinkedList<String> getSampleNames(LinkedList<String> sampleNames, DataUrl dataUrl) {
            DataBean bean = ((BeanDataFile)dataUrl).bean;
            try {
                for (int i = 0; i < sampleNames.size(); ++i) {
                    String internalName = sampleNames.get(i);
                    String sampleName = bean.queryFeatures("/phenodata/linked/describe/" + internalName).asString();
                    sampleNames.set(i, sampleName);
                }
            }
            catch (MicroarrayException e) {
                // empty catch block
            }
            return sampleNames;
        }
    }

    public static class DataBeanInterpretation
    extends Interpretation {
        public List<BeanDataFile> summaryDatas = new LinkedList<BeanDataFile>();

        public DataBeanInterpretation(Interpretation.TrackType type, BeanDataFile beanDataFile) {
            super(type, beanDataFile);
        }
    }

    public static class BeanDataFile
    extends DataUrl {
        private DataBean bean;

        public BeanDataFile(DataBean data) {
            super(null, data.getName());
            this.bean = data;
        }

        public BeanDataFile(DataBean data, String name) {
            super(null, name);
            this.bean = data;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this.bean.getContentByteStream();
        }

        @Override
        public File getLocalFile() throws IOException {
            return Session.getSession().getDataManager().getLocalFile(this.bean);
        }

        @Override
        public URL getUrl() throws IOException {
            return this.getLocalFile().toURI().toURL();
        }
    }
}

