/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.operation.parameter;

import fi.csc.microarray.client.operation.Operation;
import fi.csc.microarray.client.operation.OperationDefinition;
import fi.csc.microarray.client.operation.parameter.ParameterInputComponent;
import fi.csc.microarray.client.operation.parameter.SingleSelectionInputComponent;
import fi.csc.microarray.client.operation.parameter.SteppedComboBox;
import fi.csc.microarray.databeans.DataBean;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.apache.log4j.Logger;

public class InputFileComponent
extends JPanel {
    private static final Logger logger = Logger.getLogger(SingleSelectionInputComponent.class);
    private OperationDefinition.InputDefinition input;
    private SteppedComboBox choiceBox;
    private Operation operation;

    public InputFileComponent(OperationDefinition.InputDefinition input, Operation operation) {
        super(new BorderLayout());
        this.input = input;
        this.operation = operation;
        List<Operation.DataBinding> bindings = operation.getBindings();
        HashMap<String, String> bindingMap = new HashMap<String, String>();
        Object[] dataBeans = new DataBean[]{};
        DataBean currentBean = null;
        Boolean enabled = false;
        Integer index = 0;
        if (!bindings.isEmpty()) {
            enabled = true;
            dataBeans = new DataBean[bindings.size()];
            for (Operation.DataBinding binding : bindings) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                dataBeans[n.intValue()] = binding.getData();
                bindingMap.put(binding.getName(), binding.getData().getName());
                if (!input.idMatches(binding.getName())) continue;
                currentBean = binding.getData();
            }
        }
        this.choiceBox = new SteppedComboBox(dataBeans);
        this.choiceBox.setEnabled(enabled);
        this.choiceBox.setPreferredSize(ParameterInputComponent.PREFERRED_SIZE);
        this.choiceBox.setBackground(Color.white);
        this.choiceBox.setSelectedItem(currentBean);
        this.add((Component)this.choiceBox, "Center");
    }

    public OperationDefinition.InputDefinition getInput() {
        return this.input;
    }

    public JComboBox getChoiceBox() {
        return this.choiceBox;
    }

    public void setListener(InputFileComponentListener listener) {
        this.choiceBox.addItemListener(listener);
    }

    public JLabel getLabel() {
        return new JLabel(this.input.getDisplayName());
    }

    public class InputFileComponentListener
    implements ItemListener {
        private Object deselected;
        private Object selected;
        private List<InputFileComponent> components;

        public InputFileComponentListener(List<InputFileComponent> components) {
            this.components = components;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                this.deselected = e.getItem();
            } else {
                this.selected = e.getItem();
                logger.debug((Object)("Selected input dataset: " + this.selected + "; previously was: " + this.deselected));
                InputFileComponent.this.operation.clearBindings();
                LinkedList<Operation.DataBinding> newBindings = new LinkedList<Operation.DataBinding>();
                for (InputFileComponent component : this.components) {
                    if (component.getChoiceBox().getSelectedItem().equals(this.selected) && e.getSource() != component.getChoiceBox()) {
                        component.getChoiceBox().setSelectedItem(this.deselected);
                    }
                    DataBean selectedBean = (DataBean)component.getChoiceBox().getSelectedItem();
                    newBindings.add(new Operation.DataBinding(selectedBean, component.getInput().getID(), component.getInput().getType()));
                }
                InputFileComponent.this.operation.setBindings(newBindings);
            }
        }
    }
}

