/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.chipster.web.adminweb.ui;

import com.vaadin.data.Container;
import com.vaadin.data.Property;
import com.vaadin.server.Resource;
import com.vaadin.server.ThemeResource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.VerticalLayout;
import fi.csc.chipster.web.adminweb.ChipsterAdminUI;
import fi.csc.chipster.web.adminweb.data.JobsContainer;
import fi.csc.chipster.web.adminweb.ui.JobsTable;

public class JobsView
extends VerticalLayout
implements Button.ClickListener,
Property.ValueChangeListener {
    private HorizontalLayout toolbarLayout;
    private Button refreshButton = new Button("Refresh");
    private JobsTable table;
    private JobsContainer dataSource;
    private ChipsterAdminUI app;

    public JobsView(ChipsterAdminUI app) {
        this.app = app;
        this.dataSource = new JobsContainer();
        this.table = new JobsTable(this);
        this.table.setContainerDataSource((Container)this.dataSource);
        this.dataSource.update();
        this.table.setVisibleColumns(JobsContainer.NATURAL_COL_ORDER);
        this.table.setColumnHeaders(JobsContainer.COL_HEADERS_ENGLISH);
        this.addComponent((Component)this.getToolbar());
        this.addComponent((Component)this.table);
        this.setSizeFull();
        this.setExpandRatio((Component)this.table, 1.0f);
    }

    public HorizontalLayout getToolbar() {
        if (this.toolbarLayout == null) {
            this.toolbarLayout = new HorizontalLayout();
            this.refreshButton.addClickListener((Button.ClickListener)this);
            this.refreshButton.setIcon((Resource)new ThemeResource("../runo/icons/32/reload.png"));
            this.toolbarLayout.addComponent((Component)this.refreshButton);
            Label spaceEater = new Label(" ");
            this.toolbarLayout.addComponent((Component)spaceEater);
            this.toolbarLayout.setExpandRatio((Component)spaceEater, 1.0f);
            this.toolbarLayout.addComponent(this.app.getTitle());
            this.toolbarLayout.setWidth("100%");
            this.toolbarLayout.setStyleName("toolbar");
        }
        return this.toolbarLayout;
    }

    public void buttonClick(Button.ClickEvent event) {
        Button source = event.getButton();
        if (source == this.refreshButton) {
            this.dataSource.update();
        }
    }

    public void valueChange(Property.ValueChangeEvent event) {
        Property property = event.getProperty();
        if (property == this.table) {
            // empty if block
        }
    }

    public void cancel(Object itemId) {
        this.dataSource.removeItem(itemId);
    }
}

