/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.fonts;

import java.util.Hashtable;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.fonts.FontDescriptor;
import org.icepdf.core.pobjects.fonts.FontFile;
import org.icepdf.core.util.Library;

public abstract class Font
extends Dictionary {
    protected String name;
    protected String basefont;
    protected String subtype;
    public static final int SIMPLE_FORMAT = 1;
    public static final int CID_FORMAT = 2;
    protected int subTypeFormat = 1;
    protected FontFile font;
    protected int firstchar = 32;
    protected FontDescriptor fontDescriptor;
    protected boolean inited;
    protected boolean isAFMFont;
    protected boolean isVerticalWriting;
    protected boolean isFontSubstitution;
    protected static final String[][] TO_UNICODE = new String[][]{{"GBpc-EUC-UCS2", "GBpc-EUC-H", "GBpc-EUC-V"}, {"GBK-EUC-UCS2", "GBK-EUC-H", "GBK-EUC-V"}, {"UniGB-UCS2-H", "GB-EUC-H", "GBT-EUC-H", "GBK2K-H", "GBKp-EUC-H"}, {"UniGB-UCS2-V", "GB-EUC-V", "GBT-EUC-V", "GBK2K-V", "GBKp-EUC-V"}, {"B5pc-UCS2", "B5pc-H", "B5pc-V"}, {"ETen-B5-UCS2", "ETen-B5-H", "ETen-B5-V", "ETenms-B5-H", "ETenms-B5-V"}, {"UniCNS-UCS2-H", "HKscs-B5-H", "CNS-EUC-H"}, {"UniCNS-UCS2-V", "HKscs-B5-V", "CNS-EUC-V"}, {"90pv-RKSJ-UCS2", "90pv-RKSJ-H", "83pv-RKSJ-H"}, {"90ms-RKSJ-UCS2", "90ms-RKSJ-H", "90ms-RKSJ-V", "90msp-RKSJ-H", "90msp-RKSJ-V"}, {"UniJIS-UCS2-H", "Ext-RKSJ-H", "H", "Add-RKSJ-H", "EUC-H"}, {"UniJIS-UCS2-V", "Ext-RKSJ-V", "V", "Add-RKSJ-V", "EUC-V"}, {"KSCms-UHC-UCS2", "KSCms-UHC-H", "KSCms-UHC-V", "KSCms-UHC-HW-H", "KSCms-UHC-HW-V"}, {"KSCpc-EUC-UCS2", "KSCpc-EUC-H"}, {"UniKS-UCS2-H", "KSC-EUC-H"}, {"UniKS-UCS2-V", "KSC-EUC-V"}};
    protected static final String[] CORE14 = new String[]{"Times-Roman", "Times-Bold", "Times-Italic", "Times-BoldItalic", "Helvetica", "Helvetica-Bold", "Helvetica-Oblique", "Helvetica-BoldOblique", "Courier", "Courier-Bold", "Courier-Oblique", "Courier-BoldOblique", "Symbol", "ZapfDingbats"};
    protected static final String[][] TYPE1_FONT_NAME = new String[][]{{"Times-Roman", "Times New Roman", "TimesNewRoman", "TimesNewRomanPS", "TimesNewRomanPSMT"}, {"Times-Bold", "TimesNewRoman,Bold", "TimesNewRoman-Bold", "TimesNewRomanPS-Bold", "TimesNewRomanPS-BoldMT"}, {"Times-Italic", "TimesNewRoman,Italic", "TimesNewRoman-Italic", "TimesNewRomanPS-Italic", "TimesNewRomanPS-ItalicMT"}, {"Times-BoldItalic", "TimesNewRoman,BoldItalic", "TimesNewRoman-BoldItalic", "TimesNewRomanPS-BoldItalic", "TimesNewRomanPS-BoldItalicMT"}, {"Helvetica", "Arial", "ArialMT"}, {"Helvetica-Bold", "Helvetica,Bold", "Arial,Bold", "Arial-Bold", "Arial-BoldMT"}, {"Helvetica-Oblique", "Helvetica,Italic", "Helvetica-Italic", "Arial,Italic", "Arial-Italic", "Arial-ItalicMT"}, {"Helvetica-BoldOblique", "Helvetica,BoldItalic", "Helvetica-BoldItalic", "Arial,BoldItalic", "Arial-BoldItalic", "Arial-BoldItalicMT"}, {"Courier", "CourierNew", "CourierNewPSMT"}, {"Courier-Bold", "Courier,Bold", "CourierNew,Bold", "CourierNew-Bold", "CourierNewPS-BoldMT"}, {"Courier-Oblique", "Courier,Italic", "CourierNew-Italic", "CourierNew,Italic", "CourierNewPS-ItalicMT"}, {"Courier-BoldOblique", "Courier,BoldItalic", "CourierNew-BoldItalic", "CourierNew,BoldItalic", "CourierNewPS-BoldItalicMT"}, {"Symbol"}, {"ZapfDingbats", "Zapf-Dingbats", "Dingbats"}};

    public Font(Library library, Hashtable entries) {
        super(library, entries);
        Object o;
        this.name = library.getName(entries, "Name");
        this.subtype = library.getName(entries, "Subtype");
        this.subTypeFormat = this.subtype.equalsIgnoreCase("type0") | this.subtype.toLowerCase().indexOf("cid") != -1 ? 2 : 1;
        this.basefont = "Serif";
        if (entries.containsKey("BaseFont") && (o = entries.get("BaseFont")) instanceof Name) {
            this.basefont = ((Name)o).getName();
        }
    }

    public abstract void init();

    protected String getCanonicalName(String name) {
        String[][] arr$ = TYPE1_FONT_NAME;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            String[] aTYPE1_FONT_NAME;
            for (String anATYPE1_FONT_NAME : aTYPE1_FONT_NAME = arr$[i$]) {
                if (!name.startsWith(anATYPE1_FONT_NAME)) continue;
                return aTYPE1_FONT_NAME[0];
            }
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getSubType() {
        return this.subtype;
    }

    public int getSubTypeFormat() {
        return this.subTypeFormat;
    }

    public FontFile getFont() {
        return this.font;
    }

    public boolean isVerticalWriting() {
        return this.isVerticalWriting;
    }

    public boolean isAFMFont() {
        return this.isAFMFont;
    }

    public boolean isFontSubstitution() {
        return this.isFontSubstitution;
    }

    public boolean isCore14(String fontName) {
        for (String aCORE14 : CORE14) {
            if (!fontName.startsWith(aCORE14)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.getPObjectReference() + " FONT= " + this.basefont + " " + this.entries.toString();
    }
}

