package it.sauronsoftware.cron4j;

/**
 * This class extends Thread in the purpose of give notice to the scheduler when
 * a thread is completed.
 * 
 * @author Carlo Pelliccia
 * 
 */
class WatchedThread extends Thread {

	/**
	 * The scheduler that has spawned this thread.
	 */
	private Scheduler scheduler;

	/**
	 * Builds the thread.
	 * 
	 * @param scheduler
	 *            The scheduler spawning the thread.
	 * @param task
	 *            The task whose Runnable object that must be started in the
	 *            thread.
	 */
	public WatchedThread(Scheduler scheduler, Task task) {
		super(task.getRunnable(), "cron4j-task-" + task.getId());
		this.scheduler = scheduler;
	}

	public void run() {
		// Catch unwanted exceptions.
		try {
			super.run();
		} catch (RuntimeException t) {
			throw t;
		} catch (Error t) {
			throw t;
		} finally {
			// Notify the scheduler.
			scheduler.notifyWatchedThreadExiting(this);
		}
	}

}
