/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.graphics.text;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.icepdf.core.pobjects.graphics.text.AbstractText;
import org.icepdf.core.pobjects.graphics.text.GlyphText;
import org.icepdf.core.pobjects.graphics.text.TextSelect;
import org.icepdf.core.util.Defs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WordText
extends AbstractText
implements TextSelect {
    private static final Logger logger;
    public static int spaceFraction;
    private GlyphText currentGlyph;
    private ArrayList<GlyphText> glyphs;
    private StringBuilder text = new StringBuilder();
    private boolean isWhiteSpace;

    public WordText() {
        this.glyphs = new ArrayList(4);
    }

    public boolean isWhiteSpace() {
        return this.isWhiteSpace;
    }

    public void setWhiteSpace(boolean whiteSpace) {
        this.isWhiteSpace = whiteSpace;
    }

    protected boolean detectSpace(GlyphText sprite) {
        if (this.currentGlyph != null) {
            Rectangle2D.Float bounds1 = this.currentGlyph.getBounds();
            Rectangle2D.Float bounds2 = sprite.getBounds();
            float space = bounds2.x - (bounds1.x + bounds1.width);
            if (space <= 0.0f) {
                return false;
            }
            float tolerance = bounds1.width / (float)spaceFraction;
            return space > tolerance;
        }
        return false;
    }

    protected static boolean detectPunctuation(GlyphText sprite) {
        int c = sprite.getUnicode();
        return WordText.isPunctuation(c);
    }

    protected static boolean detectWhiteSpace(GlyphText sprite) {
        int c = sprite.getUnicode();
        return WordText.isWhiteSpace(c);
    }

    public static boolean isPunctuation(int c) {
        return c == 46 || c == 44 || c == 63 || c == 33 || c == 58 || c == 59 || c == 34 || c == 39 || c == 47 || c == 92 || c == 96 || c == 35;
    }

    public static boolean isWhiteSpace(int c) {
        return c == 32 || c == 9 || c == 13 || c == 10 || c == 12;
    }

    protected WordText buildSpaceWord(GlyphText sprite) {
        Rectangle2D.Float bounds1 = this.currentGlyph.getBounds();
        Rectangle2D.Float bounds2 = sprite.getBounds();
        float space = bounds2.x - (bounds1.x + bounds1.width);
        float maxWidth = Math.max(bounds1.width, bounds2.width) / 2.0f;
        int spaces = (int)(space / maxWidth);
        spaces = spaces < 1 ? 1 : spaces;
        float spaceWidth = space / (float)spaces;
        WordText whiteSpace = new WordText();
        double offset = bounds1.x + bounds1.width;
        Rectangle2D.Float spaceBounds = new Rectangle2D.Float(bounds1.x + bounds1.width, bounds1.y, spaceWidth, bounds1.height);
        for (int i = 0; i < spaces && i < 50; ++i) {
            GlyphText spaceText = new GlyphText((float)offset, this.currentGlyph.getY(), new Rectangle2D.Float(spaceBounds.x, spaceBounds.y, spaceBounds.width, spaceBounds.height), 32, 32);
            spaceBounds.x += spaceBounds.width;
            whiteSpace.addText(spaceText);
            whiteSpace.setWhiteSpace(true);
            offset += (double)spaceWidth;
        }
        return whiteSpace;
    }

    protected void addText(GlyphText sprite) {
        this.glyphs.add(sprite);
        this.currentGlyph = sprite;
        if (this.bounds == null) {
            Rectangle2D.Float rect = sprite.getBounds();
            this.bounds = new Rectangle2D.Float(rect.x, rect.y, rect.width, rect.height);
        } else {
            this.bounds.add(sprite.getBounds());
        }
        this.text.append((char)sprite.getUnicode());
    }

    @Override
    public Rectangle2D.Float getBounds() {
        if (this.bounds == null) {
            for (GlyphText glyph : this.glyphs) {
                if (this.bounds == null) {
                    this.bounds = new Rectangle2D.Float();
                    this.bounds.setRect(glyph.getBounds());
                    continue;
                }
                this.bounds.add(glyph.getBounds());
            }
        }
        return this.bounds;
    }

    public ArrayList<GlyphText> getGlyphs() {
        return this.glyphs;
    }

    @Override
    public StringBuilder getSelected() {
        StringBuilder selectedText = new StringBuilder();
        for (GlyphText glyph : this.glyphs) {
            if (!glyph.isSelected()) continue;
            selectedText.append((char)glyph.getUnicode());
        }
        return selectedText;
    }

    @Override
    public void clearHighlighted() {
        this.setHighlighted(false);
        this.setHasHighlight(false);
        for (GlyphText glyph : this.glyphs) {
            glyph.setHighlighted(false);
        }
    }

    @Override
    public void clearSelected() {
        this.setSelected(false);
        this.setHasSelected(false);
        for (GlyphText glyph : this.glyphs) {
            glyph.setSelected(false);
        }
    }

    @Override
    public void selectAll() {
        this.setSelected(true);
        this.setHasSelected(true);
        for (GlyphText glyph : this.glyphs) {
            glyph.setSelected(true);
        }
    }

    public String getText() {
        return this.text.toString();
    }

    public String toString() {
        return this.getText();
    }

    static {
        block2: {
            logger = Logger.getLogger(WordText.class.toString());
            try {
                spaceFraction = Defs.sysPropertyInt("org.icepdf.core.views.page.text.spaceFraction", 3);
            }
            catch (NumberFormatException e) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.warning("Error reading text selection colour");
            }
        }
    }
}

