/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.validation;

import org.apache.camel.Exchange;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.validation.PredicateValidationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PredicateValidatingProcessor
implements Processor,
Traceable {
    private static final Log LOG = LogFactory.getLog(PredicateValidatingProcessor.class);
    private final Predicate predicate;

    public PredicateValidatingProcessor(Predicate predicate) {
        this.predicate = predicate;
    }

    public void process(Exchange exchange) throws Exception {
        boolean matches = this.predicate.matches(exchange);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Validation " + (matches ? "succeed " : "failed ") + "for " + exchange + " with Predicate[" + this.predicate + "]"));
        }
        if (!matches) {
            throw new PredicateValidationException(exchange, this.predicate);
        }
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return "validate(" + this.predicate + ")";
    }

    public String getTraceLabel() {
        return "validate[" + this.predicate + "]";
    }
}

