/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import org.broad.tribble.gelitext.DiploidGenotypeException;

public enum DiploidGenotype {
    AA,
    AC,
    AG,
    AT,
    CC,
    CG,
    CT,
    GG,
    GT,
    TT;


    public static DiploidGenotype toDiploidGenotype(String genotype) {
        if (genotype.length() != 2) {
            throw new DiploidGenotypeException("Genotype string for conversion should be of length 2, we were passed = " + genotype);
        }
        genotype = genotype.toUpperCase();
        DiploidGenotype[] diploidGenotypeArray = DiploidGenotype.values();
        int n = diploidGenotypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DiploidGenotype g = diploidGenotypeArray[n2];
            if (g.toString().equals(genotype)) {
                return g;
            }
            ++n2;
        }
        throw new DiploidGenotypeException("Unable to find genotype matching " + genotype);
    }

    public boolean isHet() {
        return this.toString().toCharArray()[0] != this.toString().toCharArray()[1];
    }

    public boolean containsBase(char base) {
        return this.toString().charAt(0) == base || this.toString().charAt(1) == base;
    }
}

