/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.databeans;

import fi.csc.microarray.databeans.DataBean;
import fi.csc.microarray.databeans.DataBeanSelector;
import java.util.LinkedList;
import java.util.List;

public class LinkUtils {
    public static DataBean retrieveInherited(DataBean input, final DataBean.Link linkType) {
        List<DataBean> inheritedBeans = input.traverseLinks(DataBean.Link.derivationalTypes(), DataBean.Traversal.DIRECT, new DataBeanSelector(){

            @Override
            public boolean shouldSelect(DataBean bean) {
                return bean.getLinkSources(linkType).size() > 0;
            }

            @Override
            public boolean shouldTraverse(DataBean bean) {
                return true;
            }
        });
        if (inheritedBeans.size() > 0) {
            return inheritedBeans.get(0).getLinkSources(linkType).get(0);
        }
        return null;
    }

    public static DataBean[] retrieveOutputSet(DataBean seed) {
        DataBean origin = seed.getLinkTargets(DataBean.Link.derivationalTypes()).get(0);
        LinkedList<DataBean> outputSet = new LinkedList<DataBean>();
        for (DataBean candidateOutput : origin.getLinkSources(DataBean.Link.derivationalTypes())) {
            if (candidateOutput.getOperationRecord() != seed.getOperationRecord()) continue;
            outputSet.add(candidateOutput);
        }
        return outputSet.toArray(new DataBean[0]);
    }
}

