/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.ws.impl;

import fi.csc.microarray.analyser.ws.HtmlUtil;
import fi.csc.microarray.analyser.ws.ResultTableCollector;
import fi.csc.microarray.util.Strings;
import fi.csc.microarray.util.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EnfinWsUtils {
    public static void main(String[] args) throws SAXException, ParserConfigurationException, TransformerException, SOAPException, IOException {
        String[] probes = new String[]{"204704_s_at", "221589_s_at", "206065_s_at", "209459_s_at", "209460_at", "206024_at", "205719_s_at", "205892_s_at", "202036_s_at", "206054_at", "209443_at"};
        ResultTableCollector intactAnnotations = EnfinWsUtils.queryIntact(probes, false);
        EnfinWsUtils.writeIntactResult(intactAnnotations, new File("intact.html"), new File("intact.tsv"), false);
        ResultTableCollector reactomeAnnotations = EnfinWsUtils.queryReactome(probes, false);
        EnfinWsUtils.writeReactomeResult(reactomeAnnotations, new File("reactome.html"), new File("reactome.tsv"), false);
        String[] uniprotIds = new String[]{"P38398"};
        ResultTableCollector reactomeAnnotations2 = EnfinWsUtils.queryReactome(uniprotIds, true);
        EnfinWsUtils.writeReactomeResult(reactomeAnnotations2, new File("reactome2.html"), new File("reactome2.tsv"), true);
        ResultTableCollector intactAnnotations2 = EnfinWsUtils.queryIntact(uniprotIds, true);
        EnfinWsUtils.writeIntactResult(intactAnnotations2, new File("intact2.html"), new File("intact2.tsv"), true);
    }

    public static void writeIntactResult(ResultTableCollector intactAnnotations, File htmlFile, File textFile, boolean alreadyUniprot) throws FileNotFoundException {
        String[] columnTitles;
        String[] columns;
        HtmlUtil.ValueHtmlFormatter interactionIdFormatter = new HtmlUtil.ValueHtmlFormatter(){

            @Override
            public String format(String string, String[] currentRow) {
                return "<a href=\"http://www.ebi.ac.uk/intact/pages/interactions/interactions.xhtml?conversationContext=1&queryTxt=" + string.replace(' ', '+') + "\">" + string + "</a>";
            }
        };
        HtmlUtil.ValueHtmlFormatter uniprotFormatter = new HtmlUtil.ValueHtmlFormatter(){

            @Override
            public String format(String string, String[] currentRow) {
                String formatted = "";
                for (String protein : string.split(" ")) {
                    formatted = formatted + "<a href=\"http://www.uniprot.org/uniprot/" + protein.replace(' ', '+') + "\">" + protein + "</a> ";
                }
                return formatted;
            }
        };
        if (alreadyUniprot) {
            columns = new String[]{"Name", "Participants"};
            columnTitles = new String[]{"Interaction", "Interacting proteins"};
        } else {
            columns = new String[]{"Name", "Probe IDs", "Participants"};
            columnTitles = new String[]{"Interaction", "Probe ID", "Interacting proteins"};
        }
        HtmlUtil.writeHtmlTable(intactAnnotations, columns, columnTitles, new HtmlUtil.ValueHtmlFormatter[]{interactionIdFormatter, HtmlUtil.NO_FORMATTING_FORMATTER, uniprotFormatter}, "IntAct protein interactions", new FileOutputStream(htmlFile));
        HtmlUtil.writeTextTable(intactAnnotations, columns, columnTitles, new FileOutputStream(textFile));
    }

    public static void writeReactomeResult(ResultTableCollector reactomeAnnotations, File htmlFile, File textFile, boolean alreadyUniprot) throws FileNotFoundException {
        String secondColumnTitle;
        String secondColumn;
        HtmlUtil.ValueHtmlFormatter pathwayNameFormatter = new HtmlUtil.ValueHtmlFormatter(){

            @Override
            public String format(String string, String[] currentRow) {
                return "<a href=\"http://www.reactome.org/cgi-bin/search2?DB=gk_current&OPERATOR=ALL&QUERY=" + string.replace(' ', '+') + "&SPECIES=&SUBMIT=Go!\">" + string + "</a>";
            }
        };
        if (alreadyUniprot) {
            secondColumn = "Participants";
            secondColumnTitle = "Uniprot ID";
        } else {
            secondColumn = "Probe IDs";
            secondColumnTitle = "Probe ID's for participating proteins";
        }
        HtmlUtil.writeHtmlTable(reactomeAnnotations, new String[]{"Name", secondColumn}, new String[]{"Pathway", secondColumnTitle}, new HtmlUtil.ValueHtmlFormatter[]{pathwayNameFormatter, HtmlUtil.NO_FORMATTING_FORMATTER}, "Reactome pathway associations", new FileOutputStream(htmlFile));
        HtmlUtil.writeTextTable(reactomeAnnotations, new String[]{"Name", secondColumn}, new String[]{"Pathway", secondColumnTitle}, new FileOutputStream(textFile));
    }

    public static ResultTableCollector queryIntact(String[] probes, boolean alreadyUniprot) throws SOAPException, MalformedURLException, SAXException, IOException, ParserConfigurationException, TransformerException {
        Document uniprotResponse = alreadyUniprot ? EnfinWsUtils.convertUniprotIds(probes) : EnfinWsUtils.queryUniprotIds(probes);
        SOAPMessage intactSoapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody intactSoapBody = EnfinWsUtils.initialiseSoapBody(intactSoapMessage);
        EnfinWsUtils.attachEnfinXml(intactSoapBody, EnfinWsUtils.fetchEnfinXml(uniprotResponse), "findPartners", "http://ebi.ac.uk/enfin/core/web/services/intact");
        Document intactResponse = EnfinWsUtils.sendSoapMessage(intactSoapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/intact/service"));
        return EnfinWsUtils.collectAnnotations(intactResponse, new AnnotationIdentifier(){

            @Override
            public boolean isAnnotation(Element setElement) {
                List<Element> names = XmlUtil.getChildElements(setElement, "names");
                return !names.isEmpty() && "IntAct interaction".equals(XmlUtil.getChildElement(names.get(0), "fullName").getTextContent());
            }
        }, new AnnotationNameFinder(){

            @Override
            public String findAnnotationName(Element setElement) {
                Element primaryRef = (Element)XmlUtil.getChildElement(setElement, "xrefs").getChildNodes().item(0);
                return primaryRef.getAttribute("id");
            }
        });
    }

    private static Document convertUniprotIds(String[] probes) throws SOAPException, MalformedURLException, SAXException, IOException, ParserConfigurationException {
        SOAPMessage soapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody soapBody = EnfinWsUtils.initialiseSoapBody(soapMessage);
        SOAPElement entries = EnfinWsUtils.createOperation(soapBody, "docFromUniprotList", "http://ebi.ac.uk/enfin/core/web/services/utility");
        for (String probe : probes) {
            SOAPElement arg = entries.addChildElement("parameter");
            arg.setTextContent(probe);
        }
        Document response = EnfinWsUtils.sendSoapMessage(soapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/utility/service"));
        return response;
    }

    public static ResultTableCollector queryReactome(String[] probes, boolean alreadyUniprot) throws SOAPException, MalformedURLException, SAXException, IOException, ParserConfigurationException, TransformerException {
        Document uniprotResponse = alreadyUniprot ? EnfinWsUtils.convertUniprotIds(probes) : EnfinWsUtils.queryUniprotIds(probes);
        SOAPMessage intactSoapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody intactSoapBody = EnfinWsUtils.initialiseSoapBody(intactSoapMessage);
        EnfinWsUtils.attachEnfinXml(intactSoapBody, EnfinWsUtils.fetchEnfinXml(uniprotResponse), "findPath", "http://ebi.ac.uk/enfin/core/web/services/reactome");
        Document reactomeResponse = EnfinWsUtils.sendSoapMessage(intactSoapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/reactome/service"));
        return EnfinWsUtils.collectAnnotations(reactomeResponse, new AnnotationIdentifier(){

            @Override
            public boolean isAnnotation(Element setElement) {
                List<Element> setTypes = XmlUtil.getChildElements(setElement, "setType");
                return !setTypes.isEmpty() && "Reactome".equals(setTypes.get(0).getAttribute("db"));
            }
        }, new AnnotationNameFinder(){

            @Override
            public String findAnnotationName(Element setElement) {
                Element fullName = (Element)XmlUtil.getChildElement(setElement, "names").getChildNodes().item(0);
                return fullName.getTextContent();
            }
        });
    }

    private static Document queryUniprotIds(String[] probes) throws SOAPException, SAXException, IOException, ParserConfigurationException, MalformedURLException {
        SOAPMessage probeSoapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody probeSoapBody = EnfinWsUtils.initialiseSoapBody(probeSoapMessage);
        SOAPElement probeEntries = EnfinWsUtils.createOperation(probeSoapBody, "docFromAffyList", "http://ebi.ac.uk/enfin/core/web/services/utility");
        for (String probe : probes) {
            SOAPElement arg = probeEntries.addChildElement("parameter");
            arg.setTextContent(probe);
        }
        Document probeResponse = EnfinWsUtils.sendSoapMessage(probeSoapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/utility/service"));
        SOAPMessage uniprotSoapMessage = EnfinWsUtils.initialiseSoapMessage();
        SOAPBody uniprotSoapBody = EnfinWsUtils.initialiseSoapBody(uniprotSoapMessage);
        EnfinWsUtils.attachEnfinXml(uniprotSoapBody, EnfinWsUtils.fetchEnfinXml(probeResponse), "mapAffy2UniProt", "http://ebi.ac.uk/enfin/core/web/services/affy2uniprot");
        Document uniprotResponse = EnfinWsUtils.sendSoapMessage(uniprotSoapMessage, new URL("http://www.ebi.ac.uk/enfin-srv/encore/affy2uniprot/service"));
        return uniprotResponse;
    }

    private static Document fetchEnfinXml(Document response) throws ParserConfigurationException {
        Document document = XmlUtil.newDocument();
        document.appendChild(document.importNode(response.getDocumentElement().getElementsByTagNameNS("http://ebi.ac.uk/enfin/core/model", "entries").item(0), true));
        return document;
    }

    private static ResultTableCollector collectAnnotations(Document response, AnnotationIdentifier annotationIdentifier, AnnotationNameFinder annotationNameFinder) {
        ResultTableCollector annotationCollector = new ResultTableCollector();
        NodeList childNodes = response.getDocumentElement().getChildNodes().item(0).getChildNodes().item(0).getChildNodes().item(0).getChildNodes().item(0).getChildNodes();
        HashMap<String, String> moleculeMap = new HashMap<String, String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            if (!"molecule".equals(childNodes.item(i).getLocalName())) continue;
            Element molecule = (Element)childNodes.item(i);
            String moleculeId = molecule.getAttribute("id");
            Element primaryRef = (Element)XmlUtil.getChildElement(molecule, "xrefs").getChildNodes().item(0);
            String moleculeName = primaryRef.getAttribute("id");
            moleculeMap.put(moleculeId, moleculeName);
        }
        HashMap<String, String> proteinToAffyMap = new HashMap<String, String>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element set;
            Element setType;
            if (!"set".equals(childNodes.item(i).getLocalName()) || (setType = XmlUtil.getChildElement(set = (Element)childNodes.item(i), "setType")) == null || !"Affymetrix ID mapped to UniProt accession(s)".equals(setType.getAttribute("term"))) continue;
            List<Element> participants = XmlUtil.getChildElements(set, "participant");
            String affyRef = (String)moleculeMap.get(participants.get(0).getAttribute("moleculeRef"));
            for (int j = 1; j < participants.size(); ++j) {
                String proteinId = participants.get(j).getAttribute("moleculeRef");
                proteinToAffyMap.put(proteinId, affyRef);
            }
        }
        int index = 0;
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Element set;
            if (!"set".equals(((Element)childNodes.item(i)).getLocalName()) || !annotationIdentifier.isAnnotation(set = (Element)childNodes.item(i))) continue;
            String annotationName = annotationNameFinder.findAnnotationName(set);
            annotationCollector.addAnnotation(index, "Name", annotationName);
            HashSet<String> probeids = new HashSet<String>();
            HashSet<String> moleculeNames = new HashSet<String>();
            List<Element> participants = XmlUtil.getChildElements(set, "participant");
            for (Element participant : participants) {
                String participantValue = participant.getAttribute("moleculeRef");
                String moleculeName = (String)moleculeMap.get(participantValue);
                moleculeNames.add(moleculeName);
                String probeName = (String)proteinToAffyMap.get(participantValue);
                if (probeName == null) continue;
                probeids.add(probeName);
            }
            annotationCollector.addAnnotation(index, "Probe IDs", Strings.delimit(probeids, " "));
            annotationCollector.addAnnotation(index, "Participants", Strings.delimit(moleculeNames, " "));
            ++index;
        }
        return annotationCollector;
    }

    private static Document sendSoapMessage(SOAPMessage soapMessage, URL endpoint) throws SAXException, IOException, ParserConfigurationException, SOAPException {
        soapMessage.saveChanges();
        SOAPConnectionFactory connectionFactory = SOAPConnectionFactory.newInstance();
        SOAPConnection soapConnection = connectionFactory.createConnection();
        SOAPMessage resp = soapConnection.call(soapMessage, (Object)endpoint);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        resp.writeTo((OutputStream)out);
        soapConnection.close();
        return XmlUtil.parseReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
    }

    private static SOAPBody initialiseSoapBody(SOAPMessage message) throws SOAPException {
        SOAPPart soapPart = message.getSOAPPart();
        SOAPEnvelope soapEnvelope = soapPart.getEnvelope();
        return soapEnvelope.getBody();
    }

    private static SOAPMessage initialiseSoapMessage() throws SOAPException {
        MessageFactory mf = MessageFactory.newInstance();
        return mf.createMessage();
    }

    private static void attachEnfinXml(SOAPBody soapBody, Document enfinXml, String operation, String operationNamespace) throws SOAPException, ParserConfigurationException {
        Document document = XmlUtil.newDocument();
        document.appendChild(document.createElementNS(operationNamespace, operation));
        document.getDocumentElement().appendChild(document.importNode(enfinXml.getDocumentElement(), true));
        soapBody.addDocument(document);
    }

    private static SOAPElement createOperation(SOAPBody soapBody, String operation, String operationNamespace) throws SOAPException {
        soapBody.addNamespaceDeclaration("oper", operationNamespace);
        SOAPElement elementFindPartners = soapBody.addChildElement(operation, "oper");
        elementFindPartners.addNamespaceDeclaration("model", "http://ebi.ac.uk/enfin/core/model");
        return elementFindPartners;
    }

    static interface AnnotationNameFinder {
        public String findAnnotationName(Element var1);
    }

    static interface AnnotationIdentifier {
        public boolean isAnnotation(Element var1);
    }
}

