/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.analyser.emboss;

import fi.csc.microarray.analyser.AnalysisException;
import fi.csc.microarray.analyser.AnalysisHandler;
import fi.csc.microarray.analyser.AnalysisJob;
import fi.csc.microarray.analyser.ResultCallback;
import fi.csc.microarray.analyser.ToolDescription;
import fi.csc.microarray.analyser.ToolDescriptionGenerator;
import fi.csc.microarray.analyser.emboss.ACDDescription;
import fi.csc.microarray.analyser.emboss.ACDToSADL;
import fi.csc.microarray.analyser.emboss.EmbossAnalysisJob;
import fi.csc.microarray.description.SADLDescription;
import fi.csc.microarray.messaging.message.JobMessage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class EmbossAnalysisHandler
implements AnalysisHandler {
    private String acdDirectory;
    private String toolDirectory;
    private static final Logger logger = Logger.getLogger(EmbossAnalysisHandler.class);

    public EmbossAnalysisHandler(HashMap<String, String> parameters) {
        String externalToolPath = parameters.get("externalToolPath");
        String embossPath = parameters.get("embossPath");
        String descriptionPath = parameters.get("descriptionPath");
        this.toolDirectory = new File(externalToolPath, embossPath).getAbsolutePath();
        this.acdDirectory = new File(externalToolPath, descriptionPath).getAbsolutePath();
    }

    @Override
    public AnalysisJob createAnalysisJob(JobMessage jobMessage, ToolDescription description, ResultCallback resultCallback) {
        EmbossAnalysisJob analysisJob = new EmbossAnalysisJob(this.toolDirectory, this.acdDirectory);
        analysisJob.construct(jobMessage, description, resultCallback);
        return analysisJob;
    }

    @Override
    public ToolDescription handle(File moduleDir, String acdFileName, Map<String, String> params) throws AnalysisException {
        File acdFile = new File(this.acdDirectory, acdFileName);
        ACDDescription acdDescription = new ACDDescription(acdFile);
        logger.debug((Object)("creating description from " + acdFile.getAbsolutePath()));
        SADLDescription sadlDescription = ACDToSADL.convert(acdDescription, acdFile.getName());
        ToolDescription description = new ToolDescriptionGenerator().generate(sadlDescription, this);
        description.setCommand("EMBOSS");
        description.setSADL(sadlDescription.toString());
        description.setSourceCode(sadlDescription.toString() + "\n\n" + "Source code for the EMBOSS tools is available at " + "http://emboss.sourceforge.net/.");
        description.setToolFile(acdFile);
        description.setModuleDir(moduleDir);
        description.setHelpURL("https://extras.csc.fi/emboss/doc/programs/html/" + sadlDescription.getName().getID() + ".html");
        return description;
    }

    @Override
    public boolean isUptodate(ToolDescription description) {
        return true;
    }

    @Override
    public boolean isDisabled() {
        return false;
    }
}

