

package org.jfree.data.hc.junit;

import org.jfree.data.hc.HeatMap;
import org.jfree.data.hc.HCTreeNode;
import org.jfree.data.hc.HCDataset;
import org.jfree.data.hc.DataRangeMismatchException;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

/**
 * Some tests for the <code>org.jfree.data</code> package that can be run 
 * using JUnit.  You can find more information about JUnit at 
 * <a href="http://www.junit.org">http://www.junit.org</a>.
 */
public class HCDatasetTests extends TestCase {

    private HeatMap heatmap;
    private HCTreeNode columnTree;
    private HCTreeNode rowTree;
    private HCDataset dataset;

    /**
     * Constructs a new set of tests.
     *
     * @param name  the name of the tests.
     */
    public HCDatasetTests(String name) {
        super(name);
	this.heatmap = new HeatMap("",1,1);
	this.columnTree = new HCTreeNode(0,0);
	this.rowTree = new HCTreeNode(0,0);
	this.dataset = new HCDataset(
		this.heatmap,
		this.rowTree,
		this.columnTree
		);
    }

    /**
     * Returns a test suite to the JUnit test runner.
     *
     * @return The test suite.
     */
    public static Test suite() {
        return new TestSuite(HCDatasetTests.class);
    }

    /**
     * Runs the test suite using JUnit's text-based runner.
     * 
     * @param args  ignored.
     */
    public static void main(String[] args) {
        junit.textui.TestRunner.run(suite());
    }

    /**
     * Tests creating different datasets.
     */
    public void testConstructor() throws DataRangeMismatchException {

	HeatMap hm;
	HCTreeNode t1;
	HCTreeNode t2;
	HCDataset ds;

	hm = new HeatMap("",2,2);
	t1 = new HCTreeNode(0,0);
	t2 = new HCTreeNode(1);
	t2.setLeftChild(new HCTreeNode(0,0));
	t2.setRightChild(new HCTreeNode(0,1));

	ds = new HCDataset(hm,t2,t2);

	// TODO: wrong row sync.
	try {
	    ds = new HCDataset(hm,t1,t2);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}

	// TODO: wrong column sync.
	try {
	    ds = new HCDataset(hm,t2,t1);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}

	// TODO: wrong both syncs.
	try {
	    ds = new HCDataset(hm,t1,t1);
	    assertTrue(false);
	} catch (IllegalArgumentException e) {
	    ;
	}

	try {
	    // TODO: null heatmap.
	    ds = new HCDataset(null,t2,t2);
	    assertTrue(false);
	} catch (NullPointerException e) {
	    ;
	}
	// TODO: null row tree.
	ds = new HCDataset(hm,null,t2);
	// TODO: null col tree.
	ds = new HCDataset(hm,t2,null);

    }

    /**
     * Tests all the other methods.
     */
    public void testMethods() {

	assertTrue(this.dataset.getHeatMap() == this.heatmap);
	assertTrue(this.dataset.getColumnClusteringTree() == this.columnTree);
	assertTrue(this.dataset.getRowClusteringTree() == this.rowTree);

    }

}
