/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.util;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import junit.framework.Assert;
import org.apache.log4j.Logger;
import org.broad.tribble.util.ftp.FTPClient;
import org.broad.tribble.util.ftp.FTPReply;
import org.broad.tribble.util.ftp.FTPUtils;
import org.broad.tribble.util.ftp.UserPasswordInput;

public class SeekableFTPStreamHelper {
    private static Logger log = Logger.getLogger(SeekableFTPStreamHelper.class);
    private long position = 0L;
    private long contentLength = -1L;
    private String host;
    private String path;
    private String userInfo;
    FTPClient ftp = null;
    private UserPasswordInput userPasswordInput;

    SeekableFTPStreamHelper(URL url, UserPasswordInput userPasswordInput) throws IOException {
        this.userInfo = url.getUserInfo();
        this.host = url.getHost();
        this.path = url.getPath();
        this.userPasswordInput = userPasswordInput;
        this.ftp = FTPUtils.connect(this.host, this.userInfo, userPasswordInput);
        this.ftp.binary();
        FTPReply reply = this.ftp.size(this.path);
        if (reply.isSuccess()) {
            this.contentLength = Long.parseLong(reply.getReplyString());
        }
    }

    public void seek(long position) {
        this.position = position;
    }

    public long position() {
        return this.position;
    }

    public boolean eof() throws IOException {
        return false;
    }

    public long length() {
        return this.contentLength;
    }

    public long skip(long n) throws IOException {
        long bytesToSkip = n;
        this.position += bytesToSkip;
        if (this.ftp != null) {
            this.ftp.setRestPosition(this.position);
        }
        return bytesToSkip;
    }

    public int read(byte[] buffer, int offset, int len) throws IOException {
        if (this.ftp == null) {
            this.ftp = FTPUtils.connect(this.host, this.userInfo, this.userPasswordInput);
        }
        if (offset < 0 || len < 0 || offset + len > buffer.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        int n = 0;
        try {
            FTPReply reply = this.ftp.pasv();
            Assert.assertTrue((boolean)reply.isSuccess());
            if (this.contentLength >= 0L && this.position >= this.contentLength) {
                return -1;
            }
            if (this.position > 0L) {
                this.ftp.setRestPosition(this.position);
            }
            reply = this.ftp.retr(this.path);
            InputStream is = this.ftp.getDataStream();
            while (n < len) {
                int count = is.read(buffer, offset + n, len - n);
                if (count < 0) {
                    if (n != 0) break;
                    return -1;
                }
                n += count;
            }
            this.position += (long)n;
            int n2 = n;
            return n2;
        }
        catch (EOFException e) {
            if (n < 0) {
                return -1;
            }
            this.position += (long)n;
            int n3 = n;
            return n3;
        }
        finally {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    private void reconnect() throws IOException {
        if (this.ftp != null) {
            this.ftp.disconnect();
        }
        this.ftp = FTPUtils.connect(this.host, this.userInfo, this.userPasswordInput);
    }

    public void close() throws IOException {
        log.info((Object)"close");
        if (this.ftp != null) {
            this.ftp.disconnect();
            this.ftp = null;
        }
    }

    public int read() throws IOException {
        throw new UnsupportedOperationException("read() is not supported on SeekableHTTPStream.  Must read in blocks.");
    }
}

