/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.index;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.broad.tribble.Feature;
import org.broad.tribble.TribbleException;
import org.broad.tribble.index.Index;
import org.broad.tribble.index.IndexCreator;
import org.broad.tribble.index.IndexFactory;
import org.broad.tribble.index.interval.IntervalIndexCreator;
import org.broad.tribble.index.linear.LinearIndexCreator;
import org.broad.tribble.util.MathUtils;

public class DynamicIndexCreator
implements IndexCreator {
    IndexFactory.IndexBalanceApproach iba;
    Map<IndexFactory.IndexType, IndexCreator> creators;
    int longestFeatureLength = 0;
    MathUtils.RunningStat stats = new MathUtils.RunningStat();
    long featureCount = 0L;
    long basesSeen = 0L;
    Feature lastFeature = null;
    File inputFile;

    public DynamicIndexCreator(IndexFactory.IndexBalanceApproach iba) {
        this.iba = iba;
    }

    @Override
    public void initialize(File inputFile, int binSize) {
        this.inputFile = inputFile;
        this.creators = this.getIndexCreators(inputFile, this.iba);
    }

    @Override
    public int defaultBinSize() {
        return -1;
    }

    @Override
    public int getBinSize() {
        return -1;
    }

    @Override
    public Index finalizeIndex(long finalFilePosition) {
        LinkedHashMap<Double, IndexCreator> mapping = DynamicIndexCreator.scoreIndexes((double)this.featureCount / (double)this.basesSeen, this.creators, this.longestFeatureLength, this.iba);
        IndexCreator creator = this.getMinIndex(mapping, this.iba);
        Index idx = creator.finalizeIndex(finalFilePosition);
        idx.finalizeIndex();
        idx.addProperty("FEATURE_LENGTH_MEAN", String.valueOf(this.stats.mean()));
        idx.addProperty("FEATURE_LENGTH_STD_DEV", String.valueOf(this.stats.standardDeviation()));
        idx.addProperty("MEAN_FEATURE_VARIANCE", String.valueOf(this.stats.variance()));
        idx.addProperty("FEATURE_COUNT", String.valueOf(this.featureCount));
        return idx;
    }

    private Map<IndexFactory.IndexType, IndexCreator> getIndexCreators(File inputFile, IndexFactory.IndexBalanceApproach iba) {
        HashMap<IndexFactory.IndexType, IndexCreator> creators = new HashMap<IndexFactory.IndexType, IndexCreator>();
        if (iba == IndexFactory.IndexBalanceApproach.FOR_SIZE) {
            LinearIndexCreator linearNormal = new LinearIndexCreator();
            linearNormal.initialize(inputFile, linearNormal.defaultBinSize());
            creators.put(IndexFactory.IndexType.LINEAR, linearNormal);
            IntervalIndexCreator treeNormal = new IntervalIndexCreator();
            treeNormal.initialize(inputFile, treeNormal.defaultBinSize());
            creators.put(IndexFactory.IndexType.INTERVAL_TREE, treeNormal);
        }
        if (iba == IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME) {
            LinearIndexCreator linearSmallBin = new LinearIndexCreator();
            linearSmallBin.initialize(inputFile, Math.max(200, linearSmallBin.defaultBinSize() / 4));
            creators.put(IndexFactory.IndexType.LINEAR, linearSmallBin);
            IntervalIndexCreator treeSmallBin = new IntervalIndexCreator();
            treeSmallBin.initialize(inputFile, Math.max(20, treeSmallBin.defaultBinSize() / 8));
            creators.put(IndexFactory.IndexType.INTERVAL_TREE, treeSmallBin);
        }
        return creators;
    }

    @Override
    public void addFeature(Feature f, long filePosition) {
        ++this.featureCount;
        this.basesSeen = this.lastFeature == null ? this.basesSeen + (long)f.getStart() : (f.getStart() - this.lastFeature.getStart() >= 0 ? this.basesSeen + (long)(f.getStart() - this.lastFeature.getStart()) : this.basesSeen + (long)f.getStart());
        this.longestFeatureLength = Math.max(this.longestFeatureLength, f.getEnd() - f.getStart() + 1);
        this.stats.push(this.longestFeatureLength);
        for (IndexCreator creator : this.creators.values()) {
            creator.addFeature(f, filePosition);
        }
        if (this.lastFeature != null && f.getStart() < this.lastFeature.getStart() && this.lastFeature.getChr().equals(f.getChr())) {
            throw new TribbleException.MalformedFeatureFile("We saw a record with a start of " + f.getChr() + ":" + f.getStart() + " after a record with a start of " + this.lastFeature.getChr() + ":" + this.lastFeature.getStart(), this.inputFile.getAbsolutePath());
        }
        this.lastFeature = f;
    }

    protected static LinkedHashMap<Double, IndexCreator> scoreIndexes(double densityOfFeatures, Map<IndexFactory.IndexType, IndexCreator> indexes, int longestFeature, IndexFactory.IndexBalanceApproach iba) {
        if (indexes.size() < 1) {
            throw new IllegalArgumentException("Please specify at least one index to evaluate");
        }
        LinkedHashMap<Double, IndexCreator> scores = new LinkedHashMap<Double, IndexCreator>();
        for (Map.Entry<IndexFactory.IndexType, IndexCreator> entry : indexes.entrySet()) {
            if (entry.getValue() instanceof LinearIndexCreator) {
                double binSize = entry.getValue().getBinSize();
                scores.put(binSize * densityOfFeatures * Math.ceil((double)longestFeature / binSize), entry.getValue());
                continue;
            }
            if (entry.getValue() instanceof IntervalIndexCreator) {
                scores.put(Double.valueOf(entry.getValue().getBinSize()), entry.getValue());
                continue;
            }
            throw new TribbleException.UnableToCreateCorrectIndexType("Unknown index type, we don't have a scoring method for " + entry.getValue().getClass());
        }
        return scores;
    }

    private IndexCreator getMinIndex(Map<Double, IndexCreator> scores, IndexFactory.IndexBalanceApproach iba) {
        TreeMap<Double, IndexCreator> map = new TreeMap<Double, IndexCreator>();
        map.putAll(scores);
        IndexCreator idx = iba != IndexFactory.IndexBalanceApproach.FOR_SEEK_TIME ? (IndexCreator)map.get(map.lastKey()) : (IndexCreator)map.get(map.firstKey());
        return idx;
    }
}

