/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.BaseTest;

public class TestTreeParsing
extends BaseTest {
    public void testFlatList() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP; options {ASTLabelType=CommonTree;}\na : ID INT\n    {System.out.println($ID+\", \"+$INT);}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeParsing.assertEquals((String)"abc, 34\n", (String)string3);
    }

    public void testSimpleTree() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT -> ^(ID INT);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP; options {ASTLabelType=CommonTree;}\na : ^(ID INT)\n    {System.out.println($ID+\", \"+$INT);}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc 34");
        TestTreeParsing.assertEquals((String)"abc, 34\n", (String)string3);
    }

    public void testFlatVsTreeDecision() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b c ;\nb : ID INT -> ^(ID INT);\nc : ID INT;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP; options {ASTLabelType=CommonTree;}\na : b b ;\nb : ID INT    {System.out.print($ID+\" \"+$INT);}\n  | ^(ID INT) {System.out.print(\"^(\"+$ID+\" \"+$INT+')');}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 1 b 2");
        TestTreeParsing.assertEquals((String)"^(a 1)b 2\n", (String)string3);
    }

    public void testFlatVsTreeDecision2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : b c ;\nb : ID INT+ -> ^(ID INT+);\nc : ID INT+;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP; options {ASTLabelType=CommonTree;}\na : b b ;\nb : ID INT+    {System.out.print($ID+\" \"+$INT);}\n  | ^(x=ID (y=INT)+) {System.out.print(\"^(\"+$x+' '+$y+')');}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 1 2 3 b 4 5");
        TestTreeParsing.assertEquals((String)"^(a 3)b 5\n", (String)string3);
    }

    public void testCyclicDFALookahead() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT+ PERIOD;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nSEMI : ';' ;\nPERIOD : '.' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP; options {ASTLabelType=CommonTree;}\na : ID INT+ PERIOD {System.out.print(\"alt 1\");}  | ID INT+ SEMI   {System.out.print(\"alt 2\");}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "a 1 2 3.");
        TestTreeParsing.assertEquals((String)"alt 1\n", (String)string3);
    }

    public void testTemplateOutput() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP;\noptions {output=template; ASTLabelType=CommonTree;}\ns : a {System.out.println($a.st);};\na : ID INT -> {new StringTemplate($INT.text)}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "s", "abc 34");
        TestTreeParsing.assertEquals((String)"34\n", (String)string3);
    }

    public void testNullableChildList() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT? -> ^(ID INT?);\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP; options {ASTLabelType=CommonTree;}\na : ^(ID INT?)\n    {System.out.println($ID);}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc");
        TestTreeParsing.assertEquals((String)"abc\n", (String)string3);
    }

    public void testNullableChildList2() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : ID INT? SEMI -> ^(ID INT?) SEMI ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nSEMI : ';' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP; options {ASTLabelType=CommonTree;}\na : ^(ID INT?) SEMI\n    {System.out.println($ID);}\n  ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc;");
        TestTreeParsing.assertEquals((String)"abc\n", (String)string3);
    }

    public void testNullableChildList3() throws Exception {
        String string = "grammar T;\noptions {output=AST;}\na : x=ID INT? (y=ID)? SEMI -> ^($x INT? $y?) SEMI ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nSEMI : ';' ;\nWS : (' '|'\\n') {$channel=HIDDEN;} ;\n";
        String string2 = "tree grammar TP; options {ASTLabelType=CommonTree;}\na : ^(ID INT? b) SEMI\n    {System.out.println($ID+\", \"+$b.text);}\n  ;\nb : ID? ;\n";
        String string3 = this.execTreeParser("T.g", string, "TParser", "TP.g", string2, "TP", "TLexer", "a", "a", "abc def;");
        TestTreeParsing.assertEquals((String)"abc, def\n", (String)string3);
    }
}

