/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.loadbalancer;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.impl.converter.AsyncProcessorTypeConverter;
import org.apache.camel.processor.Traceable;
import org.apache.camel.processor.loadbalancer.LoadBalancerSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FailOverLoadBalancer
extends LoadBalancerSupport
implements Traceable {
    private final List<Class<?>> exceptions;
    private boolean roundRobin;
    private int maximumFailoverAttempts = -1;
    private final AtomicInteger counter = new AtomicInteger(-1);

    public FailOverLoadBalancer() {
        this.exceptions = null;
    }

    public FailOverLoadBalancer(List<Class<?>> exceptions) {
        this.exceptions = exceptions;
        for (Class<?> type : exceptions) {
            if (ObjectHelper.isAssignableFrom(Throwable.class, type)) continue;
            throw new IllegalArgumentException("Class is not an instance of Throwable: " + type);
        }
    }

    public List<Class<?>> getExceptions() {
        return this.exceptions;
    }

    public boolean isRoundRobin() {
        return this.roundRobin;
    }

    public void setRoundRobin(boolean roundRobin) {
        this.roundRobin = roundRobin;
    }

    public int getMaximumFailoverAttempts() {
        return this.maximumFailoverAttempts;
    }

    public void setMaximumFailoverAttempts(int maximumFailoverAttempts) {
        this.maximumFailoverAttempts = maximumFailoverAttempts;
    }

    protected boolean shouldFailOver(Exchange exchange) {
        if (exchange.getException() != null) {
            if (this.exceptions == null || this.exceptions.isEmpty()) {
                return true;
            }
            for (Class<?> exception : this.exceptions) {
                if (exchange.getException(exception) == null) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        List<Processor> processors = this.getProcessors();
        AtomicInteger index = new AtomicInteger();
        AtomicInteger attempts = new AtomicInteger();
        boolean first = true;
        if (this.isRoundRobin()) {
            if (this.counter.incrementAndGet() >= processors.size()) {
                this.counter.set(0);
            }
            index.set(this.counter.get());
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Failover starting with endpoint index " + index));
        }
        while (first || this.shouldFailOver(exchange)) {
            if (!first) {
                attempts.incrementAndGet();
                if (this.maximumFailoverAttempts > -1 && attempts.get() > this.maximumFailoverAttempts) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)("Braking out of failover after " + attempts + " failover attempts"));
                    break;
                }
                index.incrementAndGet();
                this.counter.incrementAndGet();
            } else {
                first = false;
            }
            if (index.get() >= processors.size()) {
                if (this.isRoundRobin()) {
                    this.log.debug((Object)"Failover is round robin enabled and therefore starting from the first endpoint");
                    index.set(0);
                    this.counter.set(0);
                } else {
                    this.log.debug((Object)"Braking out of failover as we reach the end of endpoints to use for failover");
                    break;
                }
            }
            this.prepareExchangeForFailover(exchange);
            Processor processor = processors.get(index.get());
            boolean sync = this.processExchange(processor, exchange, attempts, index, callback, processors);
            if (!sync) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed asynchronously"));
                }
                return false;
            }
            if (!this.log.isTraceEnabled()) continue;
            this.log.trace((Object)("Processing exchangeId: " + exchange.getExchangeId() + " is continued being processed synchronously"));
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("Failover complete for exchangeId: " + exchange.getExchangeId() + " >>> " + exchange));
        }
        callback.done(true);
        return true;
    }

    protected void prepareExchangeForFailover(Exchange exchange) {
        exchange.setException(null);
        exchange.setProperty("CamelErrorHandlerHandled", null);
        exchange.setProperty("CamelFailureHandled", null);
        exchange.setProperty("CamelExceptionCaught", null);
        exchange.getIn().removeHeader("CamelRedelivered");
        exchange.getIn().removeHeader("CamelRedeliveryCounter");
    }

    private boolean processExchange(Processor processor, Exchange exchange, AtomicInteger attempts, AtomicInteger index, AsyncCallback callback, List<Processor> processors) {
        if (processor == null) {
            throw new IllegalStateException("No processors could be chosen to process " + exchange);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Processing failover at attempt " + attempts + " for " + exchange));
        }
        AsyncProcessor albp = AsyncProcessorTypeConverter.convert(processor);
        return AsyncProcessorHelper.process(albp, exchange, new FailOverAsyncCallback(exchange, attempts, index, callback, processors));
    }

    public String toString() {
        return "FailoverLoadBalancer[" + this.getProcessors() + "]";
    }

    @Override
    public String getTraceLabel() {
        return "failover";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class FailOverAsyncCallback
    implements AsyncCallback {
        private final Exchange exchange;
        private final AtomicInteger attempts;
        private final AtomicInteger index;
        private final AsyncCallback callback;
        private final List<Processor> processors;

        private FailOverAsyncCallback(Exchange exchange, AtomicInteger attempts, AtomicInteger index, AsyncCallback callback, List<Processor> processors) {
            this.exchange = exchange;
            this.attempts = attempts;
            this.index = index;
            this.callback = callback;
            this.processors = processors;
        }

        @Override
        public void done(boolean doneSync) {
            if (doneSync) {
                return;
            }
            while (FailOverLoadBalancer.this.shouldFailOver(this.exchange)) {
                this.attempts.incrementAndGet();
                if (FailOverLoadBalancer.this.maximumFailoverAttempts > -1 && this.attempts.get() > FailOverLoadBalancer.this.maximumFailoverAttempts) {
                    if (!FailOverLoadBalancer.this.log.isDebugEnabled()) break;
                    FailOverLoadBalancer.this.log.debug((Object)("Braking out of failover after " + this.attempts + " failover attempts"));
                    break;
                }
                this.index.incrementAndGet();
                FailOverLoadBalancer.this.counter.incrementAndGet();
                if (this.index.get() >= this.processors.size()) {
                    if (FailOverLoadBalancer.this.isRoundRobin()) {
                        FailOverLoadBalancer.this.log.debug((Object)"Failover is round robin enabled and therefore starting from the first endpoint");
                        this.index.set(0);
                        FailOverLoadBalancer.this.counter.set(0);
                    } else {
                        FailOverLoadBalancer.this.log.debug((Object)"Braking out of failover as we reach the end of endpoints to use for failover");
                        break;
                    }
                }
                FailOverLoadBalancer.this.prepareExchangeForFailover(this.exchange);
                Processor processor = this.processors.get(this.index.get());
                doneSync = FailOverLoadBalancer.this.processExchange(processor, this.exchange, this.attempts, this.index, this.callback, this.processors);
                if (doneSync) continue;
                if (FailOverLoadBalancer.this.log.isTraceEnabled()) {
                    FailOverLoadBalancer.this.log.trace((Object)("Processing exchangeId: " + this.exchange.getExchangeId() + " is continued being processed asynchronously"));
                }
                return;
            }
            this.callback.done(false);
        }
    }
}

