/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.util;

import fi.csc.microarray.util.FloatArrayList;
import java.util.ArrayList;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FloatArrayListTest {
    @Test(groups={"unit"})
    public void test() {
        int size = 100000;
        int iterations = 1000;
        int tuneDownDivider = 10;
        float[] a = new float[size];
        ArrayList<Float> b = new ArrayList<Float>(size);
        FloatArrayList c = new FloatArrayList(size);
        for (int i = 0; i < size; ++i) {
            b.add(Float.valueOf(0.0f));
            c.add(0.0f);
        }
        long time1 = System.currentTimeMillis();
        for (int r = 0; r < iterations; ++r) {
            for (int i = 0; i < a.length; ++i) {
                a[i] = a[i] + 2.0f;
            }
        }
        float diff1 = System.currentTimeMillis() - time1;
        long time2 = System.currentTimeMillis();
        for (int r = 0; r < iterations / tuneDownDivider; ++r) {
            for (int i = 0; i < b.size(); ++i) {
                b.set(i, Float.valueOf(((Float)b.get(i)).floatValue() + 2.0f));
            }
        }
        float diff2 = (float)(System.currentTimeMillis() - time2) * (float)tuneDownDivider;
        long time3 = System.currentTimeMillis();
        for (int r = 0; r < iterations; ++r) {
            for (int i = 0; i < c.size(); ++i) {
                c.setFloat(i, c.get(i).floatValue() + 2.0f);
            }
        }
        float diff3 = System.currentTimeMillis() - time3;
        float result = 2.0f * (float)iterations;
        Assert.assertTrue((a.length == b.size() ? 1 : 0) != 0);
        Assert.assertTrue((b.size() == c.size() ? 1 : 0) != 0);
        for (int i = 0; i < a.length; ++i) {
            Assert.assertTrue((boolean)this.closeEnough(a[i], result), (String)("got " + a[i]));
            Assert.assertTrue((boolean)this.closeEnough(((Float)b.get(i)).floatValue() * (float)tuneDownDivider, result), (String)("got " + ((Float)b.get(i)).floatValue() * (float)tuneDownDivider));
            Assert.assertTrue((boolean)this.closeEnough(c.get(i).floatValue(), result), (String)("got " + c.get(i)));
        }
        Assert.assertTrue((diff3 / diff1 < 15.0f ? 1 : 0) != 0, (String)("FloatArrayList was " + diff3 / diff1 + " times slower than primitive array, which is too much"));
        Assert.assertTrue((diff2 / diff3 > 3.0f ? 1 : 0) != 0, (String)("FloatArrayList was only " + diff2 / diff3 + " times faster than ArrayList, which is too little"));
    }

    private boolean closeEnough(float f1, float f2) {
        return Math.abs(f1 - f2) < 0.01f;
    }
}

