/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.filebroker;

import fi.csc.microarray.config.Configuration;
import fi.csc.microarray.config.DirectoryLayout;
import fi.csc.microarray.constants.ApplicationConstants;
import fi.csc.microarray.filebroker.AuthorisedUrlRepository;
import fi.csc.microarray.filebroker.JettyFileServer;
import fi.csc.microarray.manager.ManagerClient;
import fi.csc.microarray.messaging.MessagingEndpoint;
import fi.csc.microarray.messaging.MessagingListener;
import fi.csc.microarray.messaging.MessagingTopic;
import fi.csc.microarray.messaging.NodeBase;
import fi.csc.microarray.messaging.Topics;
import fi.csc.microarray.messaging.message.BooleanMessage;
import fi.csc.microarray.messaging.message.ChipsterMessage;
import fi.csc.microarray.messaging.message.CommandMessage;
import fi.csc.microarray.messaging.message.UrlMessage;
import fi.csc.microarray.service.KeepAliveShutdownHandler;
import fi.csc.microarray.service.ShutdownCallback;
import fi.csc.microarray.util.Files;
import fi.csc.microarray.util.MemUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.jms.JMSException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

public class FileServer
extends NodeBase
implements MessagingListener,
ShutdownCallback {
    private static Logger logger;
    private MessagingEndpoint endpoint;
    private ManagerClient managerClient;
    private AuthorisedUrlRepository urlRepository;
    private File userDataRoot;
    private String publicDataPath;
    private String host;
    private int port;
    private int cleanUpTriggerLimitPercentage;
    private int cleanUpTargetPercentage;
    private int cleanUpMinimumFileAge;
    private long minimumSpaceForAcceptUpload;

    public static void main(String[] args) {
        DirectoryLayout.getInstance().getConfiguration();
        new FileServer(null);
    }

    public FileServer(String configURL) {
        try {
            DirectoryLayout.initialiseServerLayout(Arrays.asList("frontend", "filebroker"), configURL);
            Configuration configuration = DirectoryLayout.getInstance().getConfiguration();
            logger = Logger.getLogger(FileServer.class);
            File fileRepository = DirectoryLayout.getInstance().getFileRoot();
            this.host = configuration.getString("filebroker", "url");
            this.port = configuration.getInt("filebroker", "port");
            this.urlRepository = new AuthorisedUrlRepository(this.host, this.port);
            this.publicDataPath = configuration.getString("filebroker", "public-data-path");
            JettyFileServer fileServer = new JettyFileServer(this.urlRepository);
            fileServer.start(fileRepository.getPath(), this.port);
            String userDataPath = configuration.getString("filebroker", "user-data-path");
            this.userDataRoot = new File(fileRepository, userDataPath);
            this.cleanUpTriggerLimitPercentage = configuration.getInt("filebroker", "clean-up-trigger-limit-percentage");
            this.cleanUpTargetPercentage = configuration.getInt("filebroker", "clean-up-target-percentage");
            this.cleanUpMinimumFileAge = configuration.getInt("filebroker", "clean-up-minimum-file-age");
            this.minimumSpaceForAcceptUpload = 0x100000 * configuration.getInt("filebroker", "minimum-space-for-accept-upload");
            this.endpoint = new MessagingEndpoint(this);
            MessagingTopic filebrokerTopic = this.endpoint.createTopic(Topics.Name.AUTHORISED_FILEBROKER_TOPIC, MessagingTopic.AccessMode.READ);
            filebrokerTopic.setListener(this);
            this.managerClient = new ManagerClient(this.endpoint);
            KeepAliveShutdownHandler.init(this);
            logger.info((Object)("total space: " + FileUtils.byteCountToDisplaySize((long)this.userDataRoot.getTotalSpace())));
            logger.info((Object)("usable space: " + FileUtils.byteCountToDisplaySize((long)this.userDataRoot.getUsableSpace())));
            logger.info((Object)("cache clean up will start when usable space is less than: " + FileUtils.byteCountToDisplaySize((long)((long)((double)this.userDataRoot.getTotalSpace() * (double)(100 - this.cleanUpTriggerLimitPercentage) / 100.0))) + " (" + (100 - this.cleanUpTriggerLimitPercentage) + "%)"));
            logger.info((Object)("cache clean target usable space is:  " + FileUtils.byteCountToDisplaySize((long)((long)((double)this.userDataRoot.getTotalSpace() * (double)(100 - this.cleanUpTargetPercentage) / 100.0))) + " (" + (100 - this.cleanUpTargetPercentage) + "%)"));
            logger.info((Object)("minimum required space after upload: " + FileUtils.byteCountToDisplaySize((long)this.minimumSpaceForAcceptUpload)));
            logger.info((Object)("will not clean up files newer than: " + this.cleanUpMinimumFileAge / 3600 + "h"));
            logger.info((Object)("fileserver is up and running [" + ApplicationConstants.VERSION + "]"));
            logger.info((Object)("[mem: " + MemUtil.getMemInfo() + "]"));
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error((Object)e, (Throwable)e);
        }
    }

    @Override
    public String getName() {
        return "filebroker";
    }

    @Override
    public void onChipsterMessage(ChipsterMessage msg) {
        try {
            if (msg instanceof CommandMessage && "url-request".equals(((CommandMessage)msg).getCommand())) {
                CommandMessage requestMessage = (CommandMessage)msg;
                boolean useCompression = requestMessage.getParameters().contains("use-compression");
                URL url = this.urlRepository.createAuthorisedUrl(useCompression);
                UrlMessage reply = new UrlMessage(url);
                this.endpoint.replyToMessage(msg, (ChipsterMessage)reply);
                this.managerClient.urlRequest(msg.getUsername(), url);
            } else if (msg instanceof CommandMessage && "public-url-request".equals(((CommandMessage)msg).getCommand())) {
                URL url = this.getPublicUrL();
                UrlMessage reply = new UrlMessage(url);
                this.endpoint.replyToMessage(msg, (ChipsterMessage)reply);
                this.managerClient.publicUrlRequest(msg.getUsername(), url);
            } else if (msg instanceof CommandMessage && "disk-space-request".equals(((CommandMessage)msg).getCommand())) {
                this.handleSpaceRequest((CommandMessage)msg);
            } else {
                logger.error((Object)("message " + msg.getMessageID() + " not understood"));
            }
        }
        catch (Exception e) {
            logger.error((Object)e, (Throwable)e);
        }
    }

    private void handleSpaceRequest(CommandMessage requestMessage) throws JMSException {
        boolean spaceAvailable;
        long size = Long.parseLong(requestMessage.getNamedParameter("disk-space"));
        logger.debug((Object)("disk space request for " + size + " bytes"));
        logger.debug((Object)("usable space is: " + this.userDataRoot.getUsableSpace()));
        long usableSpaceSoftLimit = (long)((double)this.userDataRoot.getTotalSpace() * (double)(100 - this.cleanUpTriggerLimitPercentage) / 100.0);
        long usableSpaceHardLimit = this.minimumSpaceForAcceptUpload;
        long cleanUpTargetLimit = (long)((double)this.userDataRoot.getTotalSpace() * (double)(100 - this.cleanUpTargetPercentage) / 100.0);
        if (usableSpaceSoftLimit < usableSpaceHardLimit) {
            usableSpaceSoftLimit = usableSpaceHardLimit;
        }
        logger.debug((Object)("usable space soft limit is: " + usableSpaceSoftLimit));
        logger.debug((Object)("usable space hard limit is: " + usableSpaceHardLimit));
        if (this.userDataRoot.getUsableSpace() - size >= usableSpaceSoftLimit) {
            logger.debug((Object)"enough space available, no need to do anything");
            spaceAvailable = true;
        } else if (this.userDataRoot.getUsableSpace() - size >= usableSpaceHardLimit) {
            logger.info((Object)("space request: " + FileUtils.byteCountToDisplaySize((long)size) + " usable: " + FileUtils.byteCountToDisplaySize((long)this.userDataRoot.getUsableSpace()) + ", usable space soft limit: " + FileUtils.byteCountToDisplaySize((long)usableSpaceSoftLimit) + " (" + (100 - this.cleanUpTriggerLimitPercentage) + "%) will be reached --> scheduling clean up"));
            spaceAvailable = true;
            final long targetUsableSpace = size + cleanUpTargetLimit;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        long cleanUpBeginTime = System.currentTimeMillis();
                        logger.info((Object)("cache cleanup, target usable space: " + FileUtils.byteCountToDisplaySize((long)targetUsableSpace) + " (" + (100 - FileServer.this.cleanUpTargetPercentage) + "%)"));
                        Files.makeSpaceInDirectory(FileServer.this.userDataRoot, targetUsableSpace, FileServer.this.cleanUpMinimumFileAge, TimeUnit.SECONDS);
                        logger.info((Object)("cache cleanup took " + (System.currentTimeMillis() - cleanUpBeginTime) + " ms, usable space now " + FileUtils.byteCountToDisplaySize((long)FileServer.this.userDataRoot.getUsableSpace())));
                    }
                    catch (Exception e) {
                        logger.warn((Object)"exception while cleaning cache", (Throwable)e);
                    }
                }
            }, "chipster-fileserver-cache-cleanup").start();
        } else if (this.userDataRoot.getUsableSpace() - size > 0L) {
            logger.info((Object)("space request: " + FileUtils.byteCountToDisplaySize((long)size) + " usable: " + FileUtils.byteCountToDisplaySize((long)this.userDataRoot.getUsableSpace()) + ", not enough space --> clean up immediately"));
            try {
                long cleanUpBeginTime = System.currentTimeMillis();
                logger.info((Object)("cache cleanup, target usable space: " + FileUtils.byteCountToDisplaySize((long)(size + cleanUpTargetLimit)) + " (" + FileUtils.byteCountToDisplaySize((long)size) + " + " + FileUtils.byteCountToDisplaySize((long)cleanUpTargetLimit) + " (" + (100 - this.cleanUpTargetPercentage) + "%)"));
                Files.makeSpaceInDirectory(this.userDataRoot, size + cleanUpTargetLimit, this.cleanUpMinimumFileAge, TimeUnit.SECONDS);
                logger.info((Object)("cache cleanup took " + (System.currentTimeMillis() - cleanUpBeginTime) + " ms, usable space now " + FileUtils.byteCountToDisplaySize((long)this.userDataRoot.getUsableSpace())));
            }
            catch (Exception e) {
                logger.warn((Object)"exception while cleaning cache", (Throwable)e);
            }
            logger.info((Object)("not accepting upload if less than " + FileUtils.byteCountToDisplaySize((long)this.minimumSpaceForAcceptUpload) + " usable space after upload"));
            if (this.userDataRoot.getUsableSpace() >= size + this.minimumSpaceForAcceptUpload) {
                logger.info((Object)"enough space after cleaning");
                spaceAvailable = true;
            } else {
                logger.info((Object)"not enough space after cleaning");
                spaceAvailable = false;
            }
        } else {
            logger.info((Object)("space request: " + FileUtils.byteCountToDisplaySize((long)size) + " usable: " + FileUtils.byteCountToDisplaySize((long)this.userDataRoot.getUsableSpace()) + ", maximum space: " + FileUtils.byteCountToDisplaySize((long)this.userDataRoot.getTotalSpace()) + ", minimum usable: " + FileUtils.byteCountToDisplaySize((long)this.minimumSpaceForAcceptUpload) + " --> not possible to make enough space"));
            spaceAvailable = false;
        }
        BooleanMessage reply = new BooleanMessage(spaceAvailable);
        this.endpoint.replyToMessage(requestMessage, (ChipsterMessage)reply);
    }

    @Override
    public void shutdown() {
        logger.info((Object)"shutdown requested");
        try {
            this.endpoint.close();
        }
        catch (JMSException e) {
            logger.error((Object)"closing messaging endpoint failed", (Throwable)e);
        }
        logger.info((Object)"shutting down");
    }

    public URL getPublicUrL() throws MalformedURLException {
        return new URL(this.host + ":" + this.port + "/" + this.publicDataPath);
    }
}

