/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.track;

import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.Drawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.RectDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.drawable.TextDrawable;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.track.Track;
import java.awt.Color;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class ScatterplotTrack
extends Track {
    private static final int TOP_MARGIN = 0;
    private TreeMap<IndexKey, RegionContent> data = new TreeMap();
    private long maxBpLength;
    private long minBpLength;
    private Color color;
    private int height;
    private float minValue;
    private float maxValue;
    private ColumnType column = null;
    private int floatListIndex;

    public ScatterplotTrack(Color color, int height, float minValue, float maxValue, ColumnType column, long minBpLength, long maxBpLength) {
        this.color = color;
        this.height = height;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.column = column;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    public ScatterplotTrack(Color color, int height, float minValue, float maxValue, int floatArrayIndex, int minBpLength, long maxBpLength) {
        this.color = color;
        this.height = height;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.floatListIndex = floatArrayIndex;
        this.minBpLength = minBpLength;
        this.maxBpLength = maxBpLength;
    }

    @Override
    public Collection<Drawable> getDrawables() {
        Collection<Drawable> drawables = this.getEmptyDrawCollection();
        if (this.data != null) {
            if (this.getMinHeight() > 20) {
                drawables.add(this.getRectDrawable(0, 17, this.minValue, Color.gray));
                drawables.add(this.getRectDrawable(0, 17, this.maxValue, Color.gray));
                drawables.add(new TextDrawable(1, 12, "" + this.minValue, Color.gray));
                drawables.add(new TextDrawable(1, this.height - 0 - 2, "" + this.maxValue, Color.gray));
            }
            Iterator<IndexKey> iter = this.data.keySet().iterator();
            while (iter.hasNext()) {
                RegionContent regionContent = this.data.get(iter.next());
                if (!regionContent.region.intersects(this.getView().getBpRegion())) {
                    iter.remove();
                    continue;
                }
                int x1 = this.getView().bpToTrack(regionContent.region.start);
                int width = this.getView().bpToTrack(regionContent.region.end) - x1;
                width = Math.max(width, 2);
                Float value = null;
                if (this.column != null) {
                    Object obj = regionContent.values.get((Object)this.column);
                    if (obj != null) {
                        value = (Float)obj;
                    }
                } else {
                    List floatList = (List)regionContent.values.get((Object)ColumnType.FLOAT_LIST);
                    value = (Float)floatList.get(this.floatListIndex);
                }
                if (value == null || !(value.floatValue() >= this.minValue) || !(value.floatValue() <= this.maxValue)) continue;
                drawables.add(this.getRectDrawable(x1, width, value.floatValue(), this.color));
            }
        }
        return drawables;
    }

    public RectDrawable getRectDrawable(int x1, int width, float value, Color color) {
        int y = (int)((value - this.minValue) / (this.maxValue - this.minValue) * (float)(this.height - 0 - 2));
        Rectangle rect = new Rectangle();
        rect.y = y;
        rect.x = x1;
        rect.width = width;
        rect.height = 2;
        return new RectDrawable(rect, color, color);
    }

    @Override
    public void processAreaResult(AreaResult areaResult) {
        for (RegionContent region : areaResult.getContents()) {
            this.data.put((IndexKey)region.values.get((Object)ColumnType.ID), region);
        }
        this.getView().redraw();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && this.getView().getBpRegion().getLength() > this.minBpLength && this.getView().getBpRegion().getLength() <= this.maxBpLength;
    }

    @Override
    public int getMinHeight() {
        return this.height;
    }
}

