/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.AreaRequestHandler;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.RandomAccessLineReader;
import fi.csc.microarray.client.visualisation.methods.gbrowser.util.GBrowserException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;

public class RandomAccessLineDataSource
extends DataSource {
    private RandomAccessLineReader lineReader;

    public RandomAccessLineDataSource(URL url) throws FileNotFoundException, URISyntaxException {
        super(url, null);
        this.lineReader = new RandomAccessLineReader(url);
    }

    @Deprecated
    public RandomAccessLineDataSource(URL url, Class<? extends AreaRequestHandler> requestHandler) throws FileNotFoundException, URISyntaxException {
        super(url, requestHandler);
        this.lineReader = new RandomAccessLineReader(url);
    }

    public boolean setLineReaderPosition(long position) throws IOException, GBrowserException {
        return this.lineReader.setPosition(position);
    }

    public String getNextLine() throws IOException {
        return this.lineReader.readLine();
    }

    public String getLastLine() throws IOException, GBrowserException {
        String line;
        long maxRowLength = 1024L;
        while ((line = this.getLastLine(maxRowLength)) == null) {
            maxRowLength *= 2L;
        }
        return line;
    }

    private String getLastLine(long maxRowLength) throws IOException, GBrowserException {
        String line;
        this.setLineReaderPosition(this.length() - maxRowLength);
        String lastLine = null;
        String lineBeforeLast = null;
        while ((line = this.lineReader.readLine()) != null) {
            lineBeforeLast = lastLine;
            lastLine = line;
        }
        if (lineBeforeLast != null) {
            return lastLine;
        }
        return null;
    }

    public void close() {
        this.lineReader.close();
    }

    public long length() throws IOException {
        return this.lineReader.length();
    }
}

