/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.stack;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.DataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.LineDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.Index;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.IndexKey;
import fi.csc.microarray.client.visualisation.methods.gbrowser.stack.LineParser;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class InMemoryIndex
extends Index {
    private LineDataSource file;
    private LineParser parser;
    private TreeMap<IndexKey, String> lineMap;

    public InMemoryIndex(DataSource file, LineParser parser) throws IOException {
        this.file = (LineDataSource)file;
        this.parser = parser;
        this.readFile();
    }

    private void readFile() throws IOException {
        String line;
        this.lineMap = new TreeMap();
        long lineNumber = 0L;
        while ((line = this.file.readLine()) != null) {
            if (this.parser.setLine(line)) {
                IndexKey key = new IndexKey(this.parser.getRegion().start, lineNumber);
                this.lineMap.put(key, line);
            }
            ++lineNumber;
        }
    }

    public List<String> getFileLines() {
        LinkedList<String> lines = new LinkedList<String>();
        for (Map.Entry<IndexKey, String> entry : this.lineMap.entrySet()) {
            lines.add(entry.getValue());
        }
        return lines;
    }

    @Override
    public TreeMap<IndexKey, String> getFileLines(Region request) {
        TreeMap<IndexKey, String> lines = new TreeMap<IndexKey, String>();
        IndexKey startKey = new IndexKey(request.start, 0L);
        IndexKey endKey = new IndexKey(request.end, 0L);
        for (Map.Entry<IndexKey, String> entry : this.lineMap.subMap(startKey, endKey).entrySet()) {
            lines.put(entry.getKey(), entry.getValue());
        }
        return lines;
    }
}

