/*
 * Decompiled with CFR 0.152.
 */
package fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher;

import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.BpCoordFileRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataFetcher.FastaHandlerThread;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.ChunkDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.dataSource.FastaDataSource;
import fi.csc.microarray.client.visualisation.methods.gbrowser.fileFormat.ColumnType;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.AreaRequest;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.BpCoord;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Chromosome;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.ParsedFileResult;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.Region;
import fi.csc.microarray.client.visualisation.methods.gbrowser.message.RegionContent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class FastaFileFetcherThread
extends Thread {
    private BlockingQueue<BpCoordFileRequest> fileRequestQueue;
    private ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue;
    private FastaHandlerThread areaRequestThread;
    private Map<Chromosome, Fasta> fastas;
    private boolean poison = false;

    public FastaFileFetcherThread(BlockingQueue<BpCoordFileRequest> fileRequestQueue, ConcurrentLinkedQueue<ParsedFileResult> fileResultQueue, FastaHandlerThread areaRequestThread, FastaDataSource dataSource) {
        this.fileRequestQueue = fileRequestQueue;
        this.fileResultQueue = fileResultQueue;
        this.areaRequestThread = areaRequestThread;
        this.fastas = new TreeMap<Chromosome, Fasta>();
        for (Map.Entry<Chromosome, ChunkDataSource> entry : dataSource.entrySet()) {
            this.fastas.put(entry.getKey(), new Fasta(entry.getValue()));
        }
        this.setDaemon(true);
    }

    @Override
    public void run() {
        this.setName(this.getClass().getName());
        while (!this.poison) {
            try {
                for (BpCoordFileRequest fileRequest : this.fileRequestQueue) {
                    if (!fileRequest.getStatus().poison) continue;
                    this.poison = true;
                    return;
                }
                this.processFileRequest(this.fileRequestQueue.take());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (Fasta fasta : this.fastas.values()) {
            fasta.dataSource.close();
        }
    }

    private void processFileRequest(BpCoordFileRequest fileRequest) throws IOException {
        if (fileRequest.getStatus().poison) {
            this.poison = true;
            return;
        }
        AreaRequest request = fileRequest.areaRequest;
        ArrayList<RegionContent> resultList = new ArrayList<RegionContent>();
        Chromosome chr = request.start.chr;
        Fasta fasta = this.fastas.get(chr);
        if (fasta != null) {
            if (request.start.bp < 1L) {
                long move = 1L - request.start.bp;
                BpCoord bpCoord = request.start;
                bpCoord.bp = bpCoord.bp + move;
                bpCoord = request.end;
                bpCoord.bp = bpCoord.bp + move;
            }
            String seqence = fasta.read(request.start.bp, request.end.bp);
            LinkedHashMap<ColumnType, Object> values = new LinkedHashMap<ColumnType, Object>();
            values.put(ColumnType.SEQUENCE, seqence);
            resultList.add(new RegionContent(new Region(request), values));
            ParsedFileResult result = new ParsedFileResult(resultList, fileRequest, request, request.getStatus());
            this.fileResultQueue.add(result);
            this.areaRequestThread.notifyAreaRequestHandler();
        } else {
            System.err.println("Can't find fasta annotation file for chromosome: " + request.start.chr);
        }
    }

    @Override
    public String toString() {
        return this.getClass().getName() + " - " + this.fastas;
    }

    private class Fasta {
        private ChunkDataSource dataSource;
        private long headerLength = -1L;
        private long fileRowLength = -1L;

        public Fasta(ChunkDataSource dataSource) {
            this.dataSource = dataSource;
        }

        public void init() throws IOException {
            byte[] headBytes = new byte[10000];
            this.dataSource.read(0L, headBytes);
            String headString = new String(headBytes);
            int firstNewLine = headString.indexOf("\n");
            int secondNewLine = headString.indexOf("\n", firstNewLine + 1);
            this.headerLength = firstNewLine + 1;
            this.fileRowLength = secondNewLine - firstNewLine;
        }

        public long bpToFile(long bp) {
            long bpRowLength = this.fileRowLength - 1L;
            int rows = (int)(bp / bpRowLength);
            int column = (int)(bp % bpRowLength);
            return this.headerLength + (long)rows * this.fileRowLength + (long)column;
        }

        public String read(long bpStart, long bpEnd) throws IOException {
            --bpStart;
            --bpEnd;
            if (this.headerLength == -1L) {
                this.init();
            }
            long startPosition = this.bpToFile(bpStart);
            long endPosition = this.bpToFile(bpEnd);
            byte[] bytes = new byte[(int)(endPosition - startPosition) + 1];
            this.dataSource.read(startPosition, bytes);
            String rowSepareated = new String(bytes);
            String requestedData = rowSepareated.replace("\n", "");
            return requestedData;
        }
    }
}

